/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableList;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableMap;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public abstract class JobTemplate {
    protected final String name;
    protected final String comment;
    protected final String executable;
    protected final List<String> arguments;
    protected final Map<String, String> environments;
    protected final Map<String, String> customFields;

    protected JobTemplate(BaseBuilder<?, ?> builder) {
        this.name = builder.name;
        this.comment = builder.comment;
        this.executable = builder.executable;
        this.arguments = builder.arguments;
        this.environments = builder.environments;
        this.customFields = builder.customFields;
    }

    public abstract JobType jobType();

    public String name() {
        return this.name;
    }

    public String comment() {
        return this.comment;
    }

    public String executable() {
        return this.executable;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public Map<String, String> environments() {
        return this.environments;
    }

    public Map<String, String> customFields() {
        return this.customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobTemplate)) {
            return false;
        }
        JobTemplate that = (JobTemplate)o;
        return Objects.equals((Object)this.jobType(), (Object)that.jobType()) && Objects.equals(this.name, that.name) && Objects.equals(this.comment, that.comment) && Objects.equals(this.executable, that.executable) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.environments, that.environments) && Objects.equals(this.customFields, that.customFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobType(), this.name, this.comment, this.executable, this.arguments, this.environments, this.customFields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("  jobType=").append((Object)this.jobType()).append(",\n").append("  name='").append(this.name).append("',\n");
        if (StringUtils.isNotBlank(this.comment)) {
            sb.append("  comment='").append(this.comment).append("',\n");
        }
        sb.append("  executable='").append(this.executable).append("',\n");
        if (!this.arguments.isEmpty()) {
            sb.append("  arguments=[\n");
            this.arguments.forEach(arg -> sb.append("    ").append((String)arg).append(",\n"));
            sb.append("  ],\n");
        } else {
            sb.append("  arguments=[],\n");
        }
        if (!this.environments.isEmpty()) {
            sb.append("  environments={\n");
            this.environments.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append((String)v).append(",\n"));
            sb.append("  },\n");
        } else {
            sb.append("  environments={},\n");
        }
        if (!this.customFields.isEmpty()) {
            sb.append("  customFields={\n");
            this.customFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append((String)v).append(",\n"));
            sb.append("  }\n");
        } else {
            sb.append("  customFields={}\n");
        }
        return sb.toString();
    }

    public static abstract class BaseBuilder<B extends BaseBuilder<B, P>, P extends JobTemplate> {
        private String name;
        private String comment;
        private String executable;
        private List<String> arguments;
        private Map<String, String> environments;
        private Map<String, String> customFields;

        protected BaseBuilder() {
        }

        protected abstract B self();

        public abstract P build();

        public B withName(String name) {
            this.name = name;
            return this.self();
        }

        public B withComment(String comment) {
            this.comment = comment;
            return this.self();
        }

        public B withExecutable(String executable) {
            this.executable = executable;
            return this.self();
        }

        public B withArguments(List<String> arguments) {
            this.arguments = arguments;
            return this.self();
        }

        public B withEnvironments(Map<String, String> environments) {
            this.environments = environments;
            return this.self();
        }

        public B withCustomFields(Map<String, String> customFields) {
            this.customFields = customFields;
            return this.self();
        }

        protected void validate() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "Job name must not be null or empty");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.executable), "Executable must not be null or empty");
            this.arguments = this.arguments != null ? ImmutableList.copyOf(this.arguments) : ImmutableList.of();
            this.environments = this.environments != null ? ImmutableMap.copyOf(this.environments) : ImmutableMap.of();
            this.customFields = this.customFields != null ? ImmutableMap.copyOf(this.customFields) : ImmutableMap.of();
        }
    }

    public static enum JobType {
        SPARK,
        SHELL;

    }
}

