/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import org.apache.gravitino.dto.MetalakeDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class MetalakeResponse
extends BaseResponse {
    @JsonProperty(value="metalake")
    private final MetalakeDTO metalake;

    public MetalakeResponse(MetalakeDTO metalake) {
        super(0);
        this.metalake = metalake;
    }

    public MetalakeResponse() {
        this.metalake = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.metalake != null, "metalake must not be null");
        Preconditions.checkArgument(StringUtils.isNotBlank(this.metalake.name()), "metalake 'name' must not be null and empty");
        Preconditions.checkArgument(this.metalake.auditInfo() != null, "metalake 'audit' must not be null");
    }

    public MetalakeDTO getMetalake() {
        return this.metalake;
    }

    @Override
    public String toString() {
        return "MetalakeResponse(metalake=" + String.valueOf(this.getMetalake()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetalakeResponse)) {
            return false;
        }
        MetalakeResponse other = (MetalakeResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetalakeDTO this$metalake = this.getMetalake();
        MetalakeDTO other$metalake = other.getMetalake();
        return !(this$metalake == null ? other$metalake != null : !((Object)this$metalake).equals(other$metalake));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MetalakeResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MetalakeDTO $metalake = this.getMetalake();
        result = result * 59 + ($metalake == null ? 43 : ((Object)$metalake).hashCode());
        return result;
    }
}

