/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.mysql;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.jdbc.;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.trino.connector.catalog.HasPropertyMeta;

public class MySQLPropertyMeta
implements HasPropertyMeta {
    static final String TABLE_ENGINE = "engine";
    static final String TABLE_AUTO_INCREMENT_OFFSET = "auto_increment_offset";
    public static final String TABLE_PRIMARY_KEY = "primary_key";
    public static final String TABLE_UNIQUE_KEY = "unique_key";
    private static final List<PropertyMetadata<?>> TABLE_PROPERTY_META = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"engine", (String)"The engine that MySQL table uses", (String)"InnoDB", (boolean)false), (Object)PropertyMetadata.stringProperty((String)"auto_increment_offset", (String)"The auto increment offset for the table", null, (boolean)false), (Object)new PropertyMetadata("primary_key", "The primary keys for the table", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)value, value -> value), (Object)new PropertyMetadata("unique_key", "The unique keys for the table", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)value, value -> value));
    public static final String AUTO_INCREMENT = "auto_increment";
    public static final String DEFAULT = "default";
    private static final List<PropertyMetadata<?>> COLUMN_PROPERTY_META = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)"auto_increment", (String)"The auto increment column", (Boolean)false, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"default", (String)"The default value of column", null, (boolean)false));
    private static final List<String> filterColumnProperties = ImmutableList.of((Object)"auto_increment", (Object)"default");

    @Override
    public List<PropertyMetadata<?>> getTablePropertyMetadata() {
        return TABLE_PROPERTY_META;
    }

    @Override
    public List<PropertyMetadata<?>> getColumnPropertyMetadata() {
        return COLUMN_PROPERTY_META;
    }

    public static Set<String> getPrimaryKey(Map<String, Object> tableProperties) {
        Preconditions.checkArgument((tableProperties != null ? 1 : 0) != 0, (Object)"tableProperties is null");
        ImmutableSet.Builder primaryKeyBuilder = new ImmutableSet.Builder();
        if (tableProperties.containsKey(TABLE_PRIMARY_KEY)) {
            primaryKeyBuilder.addAll((Iterable)((List)tableProperties.get(TABLE_PRIMARY_KEY)));
        }
        return primaryKeyBuilder.build();
    }

    public static Map<String, Set<String>> getUniqueKey(Map<String, Object> tableProperties) {
        Preconditions.checkArgument((tableProperties != null ? 1 : 0) != 0, (Object)"tableProperties is null");
        .ImmutableMap.Builder uniqueKeyMapBuilder = new .ImmutableMap.Builder();
        if (tableProperties.containsKey(TABLE_UNIQUE_KEY)) {
            List uniqueKeyList = (List)tableProperties.get(TABLE_UNIQUE_KEY);
            Splitter uniqueKeyDefSplitter = Splitter.on((char)':').trimResults().omitEmptyStrings();
            Splitter columnSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
            for (String uniqueKeyDef : uniqueKeyList) {
                List uniqueKeyDefSplit = uniqueKeyDefSplitter.splitToList((CharSequence)uniqueKeyDef);
                Preconditions.checkArgument((uniqueKeyDefSplit.size() == 2 ? 1 : 0) != 0, (String)"Invalid unique key define: %s", (Object)uniqueKeyDef);
                uniqueKeyMapBuilder.put((Object)((String)uniqueKeyDefSplit.get(0)), (Object)ImmutableSet.copyOf((Collection)columnSplitter.splitToList((CharSequence)uniqueKeyDefSplit.get(1))));
            }
        }
        return uniqueKeyMapBuilder.build();
    }

    public static boolean isAutoIncrement(Map<String, Object> columnProperties) {
        Preconditions.checkArgument((columnProperties != null ? 1 : 0) != 0, (Object)"columnProperties is null");
        return (Boolean)columnProperties.getOrDefault(AUTO_INCREMENT, false);
    }

    public static String getDefaultValue(Map<String, Object> columnProperties) {
        Preconditions.checkArgument((columnProperties != null ? 1 : 0) != 0, (Object)"columnProperties is null");
        return (String)columnProperties.get(DEFAULT);
    }

    public static Map<String, Object> filterColumnProperties(Map<String, Object> columnProperties) {
        Preconditions.checkArgument((columnProperties != null ? 1 : 0) != 0, (Object)"columnProperties is null");
        return columnProperties.entrySet().stream().filter(entry -> !filterColumnProperties.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

