/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.dropwizard.samplebuilder.CustomMappingSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GravitinoSampleBuilder
extends CustomMappingSampleBuilder {
    private static final Pattern CATALOG_PATTERN = Pattern.compile(Pattern.quote("gravitino-catalog") + "\\.([^.]+)\\.([^.]+)\\.([^.]+)\\.(.+)");

    public GravitinoSampleBuilder(List<MapperConfig> mapperConfigs) {
        super(mapperConfigs);
    }

    public Collector.MetricFamilySamples.Sample createSample(String dropwizardName, String nameSuffix, List<String> additionalLabelNames, List<String> additionalLabelValues, double value) {
        Matcher matcher = CATALOG_PATTERN.matcher(dropwizardName);
        if (matcher.matches()) {
            String provider = matcher.group(1);
            String metalake = matcher.group(2);
            String catalog = matcher.group(3);
            String metricNameRest = Collector.sanitizeMetricName((String)matcher.group(4));
            String sanitizedPrefix = Collector.sanitizeMetricName((String)"gravitino-catalog");
            String prometheusName = sanitizedPrefix + "_" + metricNameRest;
            ArrayList<String> labelNames = new ArrayList<String>();
            labelNames.add("provider");
            labelNames.add("metalake");
            labelNames.add("catalog");
            labelNames.addAll(additionalLabelNames);
            ArrayList<String> labelValues = new ArrayList<String>();
            labelValues.add(provider);
            labelValues.add(metalake);
            labelValues.add(catalog);
            labelValues.addAll(additionalLabelValues);
            return new Collector.MetricFamilySamples.Sample(prometheusName, labelNames, labelValues, value);
        }
        return super.createSample(dropwizardName, nameSuffix, additionalLabelNames, additionalLabelValues, value);
    }
}

