/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.job.TemplateUpdateDTO;
import org.apache.gravitino.job.JobTemplateChange;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenameJobTemplateRequest.class, name="rename"), @JsonSubTypes.Type(value=UpdateJobTemplateCommentRequest.class, name="updateComment"), @JsonSubTypes.Type(value=UpdateJobTemplateContentRequest.class, name="updateTemplate")})
public interface JobTemplateUpdateRequest
extends RESTRequest {
    public JobTemplateChange jobTemplateChange();

    public static class UpdateJobTemplateContentRequest
    implements JobTemplateUpdateRequest {
        @JsonProperty(value="newTemplate")
        private final TemplateUpdateDTO newTemplate;

        public UpdateJobTemplateContentRequest(TemplateUpdateDTO newTemplate) {
            this.newTemplate = newTemplate;
        }

        private UpdateJobTemplateContentRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.newTemplate != null ? 1 : 0) != 0, (Object)"\"newTemplate\" is required and cannot be null");
        }

        @Override
        public JobTemplateChange jobTemplateChange() {
            return JobTemplateChange.updateTemplate((JobTemplateChange.TemplateUpdate)this.newTemplate.toTemplateUpdate());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateJobTemplateContentRequest)) {
                return false;
            }
            UpdateJobTemplateContentRequest other = (UpdateJobTemplateContentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TemplateUpdateDTO this$newTemplate = this.getNewTemplate();
            TemplateUpdateDTO other$newTemplate = other.getNewTemplate();
            return !(this$newTemplate == null ? other$newTemplate != null : !((Object)this$newTemplate).equals(other$newTemplate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateJobTemplateContentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TemplateUpdateDTO $newTemplate = this.getNewTemplate();
            result = result * 59 + ($newTemplate == null ? 43 : ((Object)$newTemplate).hashCode());
            return result;
        }

        public String toString() {
            return "JobTemplateUpdateRequest.UpdateJobTemplateContentRequest(newTemplate=" + String.valueOf(this.getNewTemplate()) + ")";
        }

        public TemplateUpdateDTO getNewTemplate() {
            return this.newTemplate;
        }
    }

    public static class UpdateJobTemplateCommentRequest
    implements JobTemplateUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        public UpdateJobTemplateCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        private UpdateJobTemplateCommentRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
        }

        @Override
        public JobTemplateChange jobTemplateChange() {
            return JobTemplateChange.updateComment((String)this.newComment);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateJobTemplateCommentRequest)) {
                return false;
            }
            UpdateJobTemplateCommentRequest other = (UpdateJobTemplateCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateJobTemplateCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public String toString() {
            return "JobTemplateUpdateRequest.UpdateJobTemplateCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class RenameJobTemplateRequest
    implements JobTemplateUpdateRequest {
        @JsonProperty(value="newName")
        private final String newName;

        public RenameJobTemplateRequest(String newName) {
            this.newName = newName;
        }

        private RenameJobTemplateRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newName), (Object)"\"newName\" is required and cannot be empty");
        }

        @Override
        public JobTemplateChange jobTemplateChange() {
            return JobTemplateChange.rename((String)this.newName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameJobTemplateRequest)) {
                return false;
            }
            RenameJobTemplateRequest other = (RenameJobTemplateRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenameJobTemplateRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public String toString() {
            return "JobTemplateUpdateRequest.RenameJobTemplateRequest(newName=" + this.getNewName() + ")";
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

