/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.client.uri.TrinoUri;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Properties;

public final class TrinoDriverUri
extends TrinoUri {
    private static final String JDBC_URL_PREFIX = "jdbc:";
    private static final String JDBC_URL_START = "jdbc:trino:";

    private TrinoDriverUri(String uri, Properties driverProperties) throws SQLException {
        super(TrinoDriverUri.parseDriverUrl(uri), driverProperties);
    }

    public static TrinoDriverUri create(String url, Properties properties) throws SQLException {
        return new TrinoDriverUri(url, MoreObjects.firstNonNull(properties, new Properties()));
    }

    public static boolean acceptsURL(String url) {
        return url.startsWith(JDBC_URL_START);
    }

    private static URI parseDriverUrl(String url) throws SQLException {
        TrinoDriverUri.validatePrefix(url);
        URI uri = TrinoDriverUri.parseUrl(url);
        if (Strings.isNullOrEmpty(uri.getHost())) {
            throw new SQLException("No host specified: " + url);
        }
        if (uri.getPort() == -1) {
            throw new SQLException("No port number specified: " + url);
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException("Invalid port number: " + url);
        }
        return uri;
    }

    private static URI parseUrl(String url) throws SQLException {
        try {
            return new URI(url.substring(JDBC_URL_PREFIX.length()));
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid JDBC URL: " + url, e);
        }
    }

    private static void validatePrefix(String url) throws SQLException {
        if (!url.startsWith(JDBC_URL_START)) {
            throw new SQLException("Invalid JDBC URL: " + url);
        }
        if (url.equals(JDBC_URL_START)) {
            throw new SQLException("Empty JDBC URL: " + url);
        }
    }
}

