/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.postgresql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.JDBCCatalogPropertyConverter;
import org.apache.gravitino.trino.connector.catalog.jdbc.postgresql.PostgreSQLMetadataAdapter;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;

public class PostgreSQLConnectorAdapter
implements CatalogConnectorAdapter {
    private static final String CONNECTOR_POSTGRESQL = "postgresql";
    private final PropertyConverter catalogConverter = new JDBCCatalogPropertyConverter();

    @Override
    public Map<String, String> buildInternalConnectorConfig(GravitinoCatalog catalog) throws Exception {
        HashMap<String, String> trinoProperty = new HashMap<String, String>(this.catalogConverter.gravitinoToEngineProperties(catalog.getProperties()));
        trinoProperty.put("postgresql.array-mapping", "AS_ARRAY");
        return trinoProperty;
    }

    @Override
    public String internalConnectorName() {
        return CONNECTOR_POSTGRESQL;
    }

    @Override
    public CatalogConnectorMetadataAdapter getMetadataAdapter() {
        return new PostgreSQLMetadataAdapter(this.getSchemaProperties(), this.getTableProperties(), Collections.emptyList());
    }
}

