/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.requests.PartitionStatisticsDropRequest;
import org.apache.gravitino.dto.requests.PartitionStatisticsUpdateRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.PartitionStatisticsListResponse;
import org.apache.gravitino.dto.stats.PartitionStatisticsDropDTO;
import org.apache.gravitino.dto.stats.PartitionStatisticsUpdateDTO;
import org.apache.gravitino.exceptions.UnmodifiableStatisticException;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.shaded.com.google.common.collect.Lists;
import org.apache.gravitino.shaded.com.google.common.collect.Maps;
import org.apache.gravitino.stats.PartitionRange;
import org.apache.gravitino.stats.PartitionStatistics;
import org.apache.gravitino.stats.PartitionStatisticsDrop;
import org.apache.gravitino.stats.PartitionStatisticsUpdate;
import org.apache.gravitino.stats.SupportsPartitionStatistics;

class MetadataObjectPartitionStatisticsOperations
implements SupportsPartitionStatistics {
    private static final String FROM = "from";
    private static final String FROM_INCLUSIVE = "fromInclusive";
    private static final String TO = "to";
    private static final String TO_INCLUSIVE = "toInclusive";
    private final RESTClient restClient;
    private final String statisticsRequestPath;

    MetadataObjectPartitionStatisticsOperations(String metalakeName, MetadataObject metadataObject, RESTClient restClient) {
        this.restClient = restClient;
        this.statisticsRequestPath = String.format("api/metalakes/%s/objects/%s/%s/statistics/partitions", RESTUtils.encodeString(metalakeName), metadataObject.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString(metadataObject.fullName()));
    }

    @Override
    public List<PartitionStatistics> listPartitionStatistics(PartitionRange range) {
        HashMap<String, String> queryParams = Maps.newHashMap();
        range.lowerPartitionName().ifPresent(from -> queryParams.put(FROM, (String)from));
        range.lowerBoundType().ifPresent(boundType -> queryParams.put(FROM_INCLUSIVE, String.valueOf(boundType == PartitionRange.BoundType.CLOSED)));
        range.upperPartitionName().ifPresent(to -> queryParams.put(TO, (String)to));
        range.upperBoundType().ifPresent(boundType -> queryParams.put(TO_INCLUSIVE, String.valueOf(boundType == PartitionRange.BoundType.CLOSED)));
        PartitionStatisticsListResponse response = this.restClient.get(this.statisticsRequestPath, queryParams, PartitionStatisticsListResponse.class, Collections.emptyMap(), ErrorHandlers.statisticsErrorHandler());
        response.validate();
        return Lists.newArrayList(response.getPartitionStatistics());
    }

    @Override
    public void updatePartitionStatistics(List<PartitionStatisticsUpdate> statisticsToUpdate) throws UnmodifiableStatisticException {
        List<PartitionStatisticsUpdateDTO> updates = statisticsToUpdate.stream().map(update -> PartitionStatisticsUpdateDTO.of(update.partitionName(), update.statistics())).collect(Collectors.toList());
        PartitionStatisticsUpdateRequest request = new PartitionStatisticsUpdateRequest(updates);
        request.validate();
        BaseResponse response = this.restClient.put(this.statisticsRequestPath, (RESTRequest)request, BaseResponse.class, Collections.emptyMap(), ErrorHandlers.statisticsErrorHandler());
        response.validate();
    }

    @Override
    public boolean dropPartitionStatistics(List<PartitionStatisticsDrop> statisticsToDrop) throws UnmodifiableStatisticException {
        PartitionStatisticsDropRequest request = new PartitionStatisticsDropRequest(statisticsToDrop.stream().map(drop -> PartitionStatisticsDropDTO.of(drop.partitionName(), drop.statisticNames())).collect(Collectors.toList()));
        request.validate();
        DropResponse response = this.restClient.post(this.statisticsRequestPath, (RESTRequest)request, DropResponse.class, Collections.emptyMap(), ErrorHandlers.statisticsErrorHandler());
        response.validate();
        return response.dropped();
    }
}

