/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.gravitino.Version;
import org.apache.gravitino.client.AuthDataProvider;
import org.apache.gravitino.client.ErrorHandler;
import org.apache.gravitino.client.GravitinoClientConfiguration;
import org.apache.gravitino.client.ObjectMapperProvider;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.responses.ErrorResponse;
import org.apache.gravitino.exceptions.RESTException;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTResponse;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.gravitino.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.collect.Maps;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIBuilder;

public class HTTPClient
implements RESTClient {
    private static final String VERSION_HEADER = "application/vnd.gravitino.v1+json";
    private final String uri;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper mapper;
    private final AuthDataProvider authDataProvider;
    private final Runnable beforeConnectHandler;
    private volatile HandlerStatus handlerStatus = HandlerStatus.Start;

    private HTTPClient(String uri, Map<String, String> baseHeaders, ObjectMapper objectMapper, AuthDataProvider authDataProvider, Runnable beforeConnectHandler, Map<String, String> properties) {
        this.uri = uri;
        this.mapper = objectMapper;
        GravitinoClientConfiguration clientConfiguration = GravitinoClientConfiguration.buildFromProperties(properties);
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setConnectionManager(HTTPClient.configureConnectionManager(clientConfiguration));
        if (baseHeaders != null) {
            clientBuilder.setDefaultHeaders(baseHeaders.entrySet().stream().map(e -> new BasicHeader((String)e.getKey(), e.getValue())).collect(Collectors.toList()));
        }
        this.httpClient = clientBuilder.build();
        this.authDataProvider = authDataProvider;
        if (beforeConnectHandler == null) {
            this.handlerStatus = HandlerStatus.Finished;
        }
        this.beforeConnectHandler = beforeConnectHandler;
    }

    private String extractResponseBodyAsString(CloseableHttpResponse response) {
        try {
            if (response.getEntity() == null) {
                return null;
            }
            return EntityUtils.toString(response.getEntity(), "UTF-8");
        }
        catch (IOException | ParseException e) {
            throw new RESTException(e, "Failed to convert HTTP response body to string", new Object[0]);
        }
    }

    private boolean isSuccessful(CloseableHttpResponse response) {
        int code = response.getCode();
        return code == 200 || code == 202 || code == 204;
    }

    private ErrorResponse buildRestErrorResponse(CloseableHttpResponse response) {
        String responseReason = response.getReasonPhrase();
        String message = responseReason != null && !responseReason.isEmpty() ? responseReason : EnglishReasonPhraseCatalog.INSTANCE.getReason(response.getCode(), null);
        return ErrorResponse.restError(message);
    }

    private void throwFailure(CloseableHttpResponse response, String responseBody, Consumer<ErrorResponse> errorHandler) {
        ErrorResponse errorResponse = null;
        if (responseBody != null) {
            try {
                errorResponse = errorHandler instanceof ErrorHandler ? ((ErrorHandler)errorHandler).parseResponse(response.getCode(), responseBody, this.mapper) : ErrorResponse.unknownError(String.format("Unknown error handler %s, response body won't be parsed %s", errorHandler.getClass().getName(), responseBody));
            }
            catch (UncheckedIOException | IllegalArgumentException runtimeException) {
                // empty catch block
            }
        }
        if (errorResponse == null) {
            errorResponse = this.buildRestErrorResponse(response);
        }
        errorHandler.accept(errorResponse);
        throw new RESTException("Unhandled error: %s", errorResponse);
    }

    private URI buildUri(String path, Map<String, String> params) {
        String baseUri = String.format("%s/%s", this.uri, path);
        try {
            URIBuilder builder = new URIBuilder(baseUri);
            if (params != null) {
                params.forEach(builder::addParameter);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RESTException("Failed to create request URI from base %s, params %s", baseUri, params);
        }
    }

    private <T> T execute(Method method, String path, Map<String, String> queryParams, Object requestBody, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(method, path, queryParams, requestBody, responseType, headers, errorHandler, h2 -> {});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Method method, String path, Map<String, String> queryParams, Object requestBody, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        if (this.handlerStatus != HandlerStatus.Finished) {
            this.performPreConnectHandler();
        }
        if (path.startsWith("/")) {
            throw new RESTException("Received a malformed path for a REST request: %s. Paths should not start with /", path);
        }
        HttpUriRequestBase request = new HttpUriRequestBase(method.name(), this.buildUri(path, queryParams));
        if (requestBody instanceof Map) {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
            request.setEntity(this.toFormEncoding((Map)requestBody));
        } else if (requestBody != null) {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_JSON.getMimeType());
            request.setEntity(this.toJson(requestBody));
        } else {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_JSON.getMimeType());
        }
        if (this.authDataProvider != null) {
            request.setHeader("Authorization", new String(this.authDataProvider.getTokenData(), StandardCharsets.UTF_8));
        }
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            T t2;
            HashMap<String, String> respHeaders = Maps.newHashMap();
            for (Header header : response.getHeaders()) {
                respHeaders.put(header.getName(), header.getValue());
            }
            responseHeaders.accept(respHeaders);
            if (response.getCode() == 204 || responseType == null && this.isSuccessful(response)) {
                Header[] headerArray = null;
                return (T)headerArray;
            }
            String responseBody = this.extractResponseBodyAsString(response);
            if (!this.isSuccessful(response)) {
                this.throwFailure(response, responseBody, errorHandler);
            }
            if (responseBody == null) {
                throw new RESTException("Invalid (null) response body for request (expected %s): method=%s, path=%s, status=%d", responseType != null ? responseType.getSimpleName() : "unknown", method.name(), path, response.getCode());
            }
            try {
                t2 = this.mapper.readValue(responseBody, responseType);
            }
            catch (JsonProcessingException e) {
                throw new RESTException(e, "Received a success response code of %d, but failed to parse response body into %s", response.getCode(), responseType != null ? responseType.getSimpleName() : "unknown");
            }
            return t2;
        }
        catch (IOException e) {
            throw new RESTException(e, "Error occurred while processing %s request", new Object[]{method});
        }
    }

    private synchronized void performPreConnectHandler() {
        if (this.handlerStatus == HandlerStatus.Start) {
            this.handlerStatus = HandlerStatus.Running;
            try {
                this.beforeConnectHandler.run();
                this.handlerStatus = HandlerStatus.Finished;
            }
            catch (Exception e) {
                this.handlerStatus = HandlerStatus.Start;
                throw e;
            }
        }
    }

    @Override
    public void head(String path, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        this.execute(Method.HEAD, path, null, null, null, headers, errorHandler);
    }

    @Override
    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.GET, path, queryParams, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, body, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, body, responseType, headers, errorHandler, responseHeaders));
    }

    @Override
    public <T extends RESTResponse> T put(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.PUT, path, null, body, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T put(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        return (T)((RESTResponse)this.execute(Method.PUT, path, null, body, responseType, headers, errorHandler, responseHeaders));
    }

    @Override
    public <T extends RESTResponse> T patch(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.PATCH, path, null, body, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.DELETE, path, null, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.DELETE, path, queryParams, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T postForm(String path, Map<String, String> formData, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, formData, responseType, headers, errorHandler));
    }

    private void addRequestHeaders(HttpUriRequest request, Map<String, String> requestHeaders, String bodyMimeType) {
        request.setHeader("Content-Type", bodyMimeType);
        request.setHeader("Accept", VERSION_HEADER);
        if (StringUtils.isNotBlank(Version.getCurrentVersion().version)) {
            request.setHeader("X-Client-Version", Version.getCurrentVersion().version);
        }
        if (requestHeaders != null) {
            requestHeaders.forEach(request::setHeader);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.authDataProvider != null) {
            this.authDataProvider.close();
        }
        this.httpClient.close(CloseMode.GRACEFUL);
    }

    public static Builder builder(Map<String, String> properties) {
        return new Builder(properties);
    }

    private static HttpClientConnectionManager configureConnectionManager(GravitinoClientConfiguration clientConfiguration) {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        ConnectionConfig connectionConfig = HTTPClient.configureConnectionConfig(clientConfiguration);
        connectionManagerBuilder.setDefaultConnectionConfig(connectionConfig);
        return connectionManagerBuilder.build();
    }

    @VisibleForTesting
    static ConnectionConfig configureConnectionConfig(GravitinoClientConfiguration clientConfiguration) {
        ConnectionConfig.Builder connConfigBuilder = ConnectionConfig.custom();
        connConfigBuilder.setConnectTimeout(clientConfiguration.getClientConnectionTimeoutMs(), TimeUnit.MILLISECONDS);
        connConfigBuilder.setSocketTimeout(clientConfiguration.getClientSocketTimeoutMs(), TimeUnit.MILLISECONDS);
        return connConfigBuilder.build();
    }

    private StringEntity toJson(Object requestBody) {
        try {
            return new StringEntity(this.mapper.writeValueAsString(requestBody), StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new RESTException(e, "Failed to write request body: %s", requestBody);
        }
    }

    private StringEntity toFormEncoding(Map<?, ?> formData) {
        return new StringEntity(RESTUtils.encodeFormData(formData));
    }

    static enum HandlerStatus {
        Start,
        Finished,
        Running;

    }

    public static class Builder {
        private final Map<String, String> properties;
        private final Map<String, String> baseHeaders = Maps.newHashMap();
        private String uri;
        private ObjectMapper mapper = ObjectMapperProvider.objectMapper();
        private AuthDataProvider authDataProvider;
        private Runnable beforeConnectHandler;

        private Builder(Map<String, String> properties) {
            this.properties = properties;
        }

        public Builder uri(String baseUri) {
            Preconditions.checkNotNull(baseUri, "Invalid uri for http client: null");
            this.uri = RESTUtils.stripTrailingSlash(baseUri);
            return this;
        }

        public Builder withHeader(String key, String value) {
            this.baseHeaders.put(key, value);
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.baseHeaders.putAll(headers);
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.mapper = objectMapper;
            return this;
        }

        public Builder withPreConnectHandler(Runnable beforeConnectHandler) {
            this.beforeConnectHandler = beforeConnectHandler;
            return this;
        }

        public Builder withAuthDataProvider(AuthDataProvider authDataProvider) {
            this.authDataProvider = authDataProvider;
            return this;
        }

        public HTTPClient build() {
            return new HTTPClient(this.uri, this.baseHeaders, this.mapper, this.authDataProvider, this.beforeConnectHandler, this.properties);
        }
    }
}

