/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.sink.compactor.FileCompactor;
import org.apache.flink.core.fs.Path;

@PublicEvolving
public class RecordWiseFileCompactor<IN>
implements FileCompactor {
    private final Reader.Factory<IN> readerFactory;

    public RecordWiseFileCompactor(Reader.Factory<IN> readerFactory) {
        this.readerFactory = readerFactory;
    }

    public void compact(List<Path> inputFiles, Writer<IN> writer) throws Exception {
        for (Path input : inputFiles) {
            Reader<IN> reader = this.readerFactory.createFor(input);
            try {
                IN elem;
                while ((elem = reader.read()) != null) {
                    writer.write(elem);
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    public static interface Reader<T>
    extends AutoCloseable {
        public T read() throws IOException;

        public static interface Factory<T>
        extends Serializable {
            public Reader<T> createFor(Path var1) throws IOException;
        }
    }

    @PublicEvolving
    public static interface Writer<T> {
        public void write(T var1) throws IOException;
    }
}

