/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

@Internal
public class ObjectOfInputTypeStrategy
implements InputTypeStrategy {
    private static final ArgumentCount AT_LEAST_ONE_ODD = new ArgumentCount(){

        @Override
        public boolean isValidCount(int count) {
            return count % 2 == 1;
        }

        @Override
        public Optional<Integer> getMinCount() {
            return Optional.of(1);
        }

        @Override
        public Optional<Integer> getMaxCount() {
            return Optional.empty();
        }
    };

    private static void validateClassArgument(CallContext callContext, DataType firstArgumentDataType) {
        LogicalType classArgumentType = firstArgumentDataType.getLogicalType();
        if (!classArgumentType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            String errorMessage = String.format("The first argument must be a non-nullable character string representing the class name, but was %s.", classArgumentType.asSummaryString());
            throw new ValidationException(errorMessage);
        }
        Optional<String> argumentValue = callContext.getArgumentValue(0, String.class);
        if (argumentValue.isEmpty()) {
            String errorMessage = "The first argument must be a non-nullable character string literal representing the class name.";
            throw new ValidationException("The first argument must be a non-nullable character string literal representing the class name.");
        }
    }

    private static void validateKeyArguments(CallContext callContext, List<DataType> argumentDataTypes) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (int i = 1; i < argumentDataTypes.size(); i += 2) {
            LogicalType fieldNameLogicalType = argumentDataTypes.get(i).getLogicalType();
            ObjectOfInputTypeStrategy.validateFieldNameArgument(callContext, i, fieldNameLogicalType, fieldNames);
        }
    }

    private static void validateFieldNameArgument(CallContext callContext, int pos, LogicalType logicalType, Set<String> fieldNames) {
        if (!logicalType.is(LogicalTypeFamily.CHARACTER_STRING)) {
            String message = String.format("The field key at position %d must be a non-nullable character string, but was %s.", pos + 1, logicalType.asSummaryString());
            throw new ValidationException(message);
        }
        Optional<String> argumentValue = callContext.getArgumentValue(pos, String.class);
        if (argumentValue.isEmpty()) {
            String message = String.format("The field key at position %d must be a non-nullable character string literal.", pos + 1);
            throw new ValidationException(message);
        }
        String fieldName = argumentValue.orElseThrow(IllegalStateException::new);
        if (!fieldNames.add(fieldName)) {
            String message = String.format("The field name '%s' at position %d is repeated.", fieldName, pos + 1);
            throw new ValidationException(message);
        }
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return AT_LEAST_ONE_ODD;
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        try {
            ObjectOfInputTypeStrategy.validateClassArgument(callContext, argumentDataTypes.get(0));
            ObjectOfInputTypeStrategy.validateKeyArguments(callContext, argumentDataTypes);
        }
        catch (ValidationException e) {
            callContext.fail(throwOnFailure, e.getMessage(), argumentDataTypes);
        }
        return Optional.of(argumentDataTypes);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        ArrayList<Signature.Argument> arguments = new ArrayList<Signature.Argument>();
        Signature.Argument classArgument = Signature.Argument.of("class name", "STRING");
        arguments.add(classArgument);
        arguments.add(Signature.Argument.ofVarying("[STRING, ANY]*"));
        return List.of(Signature.of(arguments));
    }
}

