/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;

@PublicEvolving
public class NestedFieldReferenceExpression
implements ResolvedExpression {
    private final String[] fieldNames;
    private final int[] fieldIndices;
    private final DataType dataType;

    public NestedFieldReferenceExpression(String[] fieldNames, int[] fieldIndices, DataType dataType) {
        this.fieldNames = fieldNames;
        this.fieldIndices = fieldIndices;
        this.dataType = dataType;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int[] getFieldIndices() {
        return this.fieldIndices;
    }

    public String getName() {
        return String.format("`%s`", String.join((CharSequence)".", (CharSequence[])Arrays.stream(this.fieldNames).map(this::quoteIdentifier).toArray(String[]::new)));
    }

    @Override
    public DataType getOutputDataType() {
        return this.dataType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    @Override
    public String asSummaryString() {
        return this.getName();
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedFieldReferenceExpression that = (NestedFieldReferenceExpression)o;
        return Arrays.equals(this.fieldNames, that.fieldNames) && Arrays.equals(this.fieldIndices, that.fieldIndices) && this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.fieldNames), Arrays.hashCode(this.fieldIndices), this.dataType);
    }

    public String toString() {
        return this.asSummaryString();
    }

    private String quoteIdentifier(String identifier) {
        return identifier.replace("`", "``");
    }
}

