/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.CatalogDescriptor;

@Internal
public interface CatalogChange {
    public CatalogDescriptor applyChange(CatalogDescriptor var1);

    @Internal
    public static class CatalogCommentChange
    implements CatalogChange {
        private final String newComment;

        public CatalogCommentChange(String newComment) {
            this.newComment = newComment;
        }

        @Override
        public CatalogDescriptor applyChange(CatalogDescriptor descriptor) {
            return descriptor.setComment(this.newComment);
        }
    }

    @Internal
    public static class CatalogConfigurationChange
    implements CatalogChange {
        private final Consumer<Configuration> configUpdater;

        public CatalogConfigurationChange(Consumer<Configuration> configUpdater) {
            this.configUpdater = configUpdater;
        }

        @Override
        public CatalogDescriptor applyChange(CatalogDescriptor descriptor) {
            Configuration conf = descriptor.getConfiguration();
            this.configUpdater.accept(conf);
            return CatalogDescriptor.of(descriptor.getCatalogName(), conf, descriptor.getComment().orElse(null));
        }
    }
}

