/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;

public class NodeId {
    private final String pageName;
    private final EventId eventId;

    public NodeId(EventId eventId, String pageName) {
        this.eventId = eventId;
        this.pageName = pageName;
    }

    public EventId getEventId() {
        return this.eventId;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeId nodeId = (NodeId)o;
        return Objects.equals(this.eventId, nodeId.eventId) && Objects.equals(this.pageName, nodeId.pageName);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.pageName);
    }

    public String toString() {
        return "NodeId{eventId=" + String.valueOf(this.eventId) + ", pageName='" + this.pageName + "'}";
    }

    public static class NodeIdSerializer
    extends TypeSerializerSingleton<NodeId> {
        private static final long serialVersionUID = 9209498028181378582L;
        private TypeSerializer<EventId> eventIdSerializer;

        public NodeIdSerializer() {
            this((TypeSerializer<EventId>)EventId.EventIdSerializer.INSTANCE);
        }

        private NodeIdSerializer(TypeSerializer<EventId> eventIdSerializer) {
            this.eventIdSerializer = (TypeSerializer)Preconditions.checkNotNull(eventIdSerializer);
        }

        public boolean isImmutableType() {
            return true;
        }

        public NodeId createInstance() {
            return null;
        }

        public NodeId copy(NodeId from) {
            return new NodeId(from.eventId, from.pageName);
        }

        public NodeId copy(NodeId from, NodeId reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(NodeId record, DataOutputView target) throws IOException {
            if (record != null) {
                target.writeByte(1);
                this.eventIdSerializer.serialize((Object)record.eventId, target);
                StringValue.writeString((CharSequence)record.pageName, (DataOutput)target);
            } else {
                target.writeByte(0);
            }
        }

        public NodeId deserialize(DataInputView source) throws IOException {
            byte b = source.readByte();
            if (b == 0) {
                return null;
            }
            EventId eventId = (EventId)this.eventIdSerializer.deserialize(source);
            String pageName = StringValue.readString((DataInput)source);
            return new NodeId(eventId, pageName);
        }

        public NodeId deserialize(NodeId reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeByte((int)source.readByte());
            this.eventIdSerializer.copy(source, target);
            StringValue.copyString((DataInput)source, (DataOutput)target);
        }

        public TypeSerializerSnapshot<NodeId> snapshotConfiguration() {
            return new NodeIdSerializerSnapshot(this);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.eventIdSerializer == null) {
                this.eventIdSerializer = EventId.EventIdSerializer.INSTANCE;
            }
        }

        public static final class NodeIdSerializerSnapshot
        extends CompositeTypeSerializerSnapshot<NodeId, NodeIdSerializer> {
            private static final int VERSION = 1;

            public NodeIdSerializerSnapshot() {
            }

            public NodeIdSerializerSnapshot(NodeIdSerializer nodeIdSerializer) {
                super((TypeSerializer)nodeIdSerializer);
            }

            protected int getCurrentOuterSnapshotVersion() {
                return 1;
            }

            protected NodeIdSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
                return new NodeIdSerializer((TypeSerializer<EventId>)((EventId.EventIdSerializer)nestedSerializers[0]));
            }

            protected TypeSerializer<?>[] getNestedSerializers(NodeIdSerializer outerSerializer) {
                return new TypeSerializer[]{outerSerializer.eventIdSerializer};
            }
        }
    }
}

