/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer;

import java.util.List;
import java.util.Objects;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.model.Column;
import org.apache.torque.templates.model.Domain;
import org.apache.torque.templates.platform.Platform;
import org.apache.torque.templates.platform.PlatformFactory;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public final class SchemaTypeHelper {
    private SchemaTypeHelper() {
    }

    public static SchemaType getSchemaType(SourceElement columnElement, ControllerState controllerState) throws SourceTransformerException {
        String columnNameFromSchema = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        if (columnNameFromSchema == null) {
            throw new SourceTransformerException("The attribute " + TorqueSchemaAttributeName.NAME.getName() + " on element " + columnElement.getName() + " is null");
        }
        SchemaType schemaType = null;
        SqlType domain = SchemaTypeHelper.getDomain(columnElement, controllerState);
        if (domain != null && domain.getSqlTypeName() != null) {
            try {
                schemaType = SchemaType.valueOf(domain.getSqlTypeName());
            }
            catch (IllegalArgumentException e) {
                throw new SourceTransformerException("Unknown type " + domain.getSqlTypeName() + " in Domain definition");
            }
        }
        String schemaTypeString = (String)columnElement.getAttribute(TorqueSchemaAttributeName.TYPE.getName());
        if (schemaTypeString == null) {
            throw new SourceTransformerException("type attribute not set in Column " + columnNameFromSchema);
        }
        try {
            schemaType = SchemaType.valueOf(schemaTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new SourceTransformerException("Unknown type " + schemaTypeString + " in Column " + columnNameFromSchema);
        }
        return schemaType;
    }

    public static SchemaType getSchemaType(Column column, ControllerState controllerState) throws SourceTransformerException {
        if (column.name == null) {
            throw new SourceTransformerException("The attribute " + TorqueSchemaAttributeName.NAME.getName() + " on element " + String.valueOf((Object)TorqueSchemaElementName.COLUMN) + " is null");
        }
        SchemaType schemaType = null;
        SqlType domain = SchemaTypeHelper.getDomain(column, controllerState);
        if (domain != null && domain.getSqlTypeName() != null) {
            try {
                schemaType = SchemaType.valueOf(domain.getSqlTypeName());
            }
            catch (IllegalArgumentException e) {
                throw new SourceTransformerException("Unknown type " + domain.getSqlTypeName() + " in Domain definition");
            }
        }
        if (column.type == null) {
            throw new SourceTransformerException("type attribute not set in Column " + column.name);
        }
        try {
            schemaType = SchemaType.valueOf(column.type);
        }
        catch (IllegalArgumentException e) {
            throw new SourceTransformerException("Unknown type " + column.type + " in Column " + column.name);
        }
        return schemaType;
    }

    public static SqlType getSqlType(SchemaType schemaType, SqlType domainType, ControllerState controllerState, String size, String scale, String defaultValue) {
        Platform platform = PlatformFactory.getPlatformFor(controllerState.getStringOption((OptionName)TemplateOptionName.DATABASE));
        SqlType platformSqlType = platform.getSqlTypeForSchemaType(schemaType);
        if (domainType != null) {
            if (size == null) {
                size = domainType.getSize();
            }
            if (scale == null) {
                scale = domainType.getScale();
            }
            if (defaultValue == null) {
                defaultValue = domainType.getDefaultValue();
            }
        }
        SqlType result = platformSqlType.getNew(size, scale, defaultValue);
        return result;
    }

    public static SqlType getDomain(SourceElement columnElement, ControllerState controllerState) throws SourceTransformerException {
        String domainNameFromSchema = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DOMAIN);
        if (domainNameFromSchema == null) {
            return null;
        }
        SourceElement domainElement = null;
        SourceElement databaseElement = columnElement.getParent().getParent();
        List domainElementList = databaseElement.getChildren((SourceElementName)TorqueSchemaElementName.DOMAIN);
        for (SourceElement candidate : domainElementList) {
            if (!domainNameFromSchema.equals(candidate.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME))) continue;
            domainElement = candidate;
            break;
        }
        if (domainElement == null) {
            throw new SourceTransformerException("The domain named " + domainNameFromSchema + " referenced by the column " + String.valueOf(columnElement.getParent().getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME)) + " in the table " + String.valueOf(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME)) + " was not found in this schema");
        }
        String sqlType = Objects.toString(domainElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.TYPE), null);
        String defaultValue = Objects.toString(domainElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT), null);
        String size = Objects.toString(domainElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.SIZE), null);
        String scale = Objects.toString(domainElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.SCALE), null);
        return new SqlType(sqlType, size, scale, defaultValue);
    }

    public static SqlType getDomain(Column column, ControllerState controllerState) throws SourceTransformerException {
        if (column.domain == null) {
            return null;
        }
        Domain domain = null;
        for (Domain candidate : column.parent.parent.domainList) {
            if (!column.domain.equals(candidate.name)) continue;
            domain = candidate;
            break;
        }
        if (domain == null) {
            throw new SourceTransformerException("The domain named " + column.domain + " referenced by the column " + column.name + " in the table " + column.parent.name + " was not found in this schema");
        }
        return new SqlType(domain.type, domain.size, domain.scale, domain._default);
    }
}

