/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.CollationKeyFn;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.StringValue;

public class AlphanumericCollator
implements StringCollator {
    private final StringCollator baseCollator;
    private static final ARegularExpression pattern = ARegularExpression.compile("\\d+", "");
    public static final String PREFIX = "http://saxon.sf.net/collation/alphaNumeric?base=";

    public AlphanumericCollator(StringCollator base) {
        this.baseCollator = base;
    }

    @Override
    public String getCollationURI() {
        return PREFIX + this.baseCollator.getCollationURI();
    }

    @Override
    public int compareStrings(UnicodeString cs1, UnicodeString cs2) {
        UnicodeString u2;
        UnicodeString u1;
        StringValue sv2;
        BigInteger n2;
        StringValue sv1;
        BigInteger n1;
        int c;
        boolean numeric2;
        boolean numeric1;
        RegexIterator iter1 = pattern.analyze(cs1);
        RegexIterator iter2 = pattern.analyze(cs2);
        do {
            sv1 = iter1.next();
            sv2 = iter2.next();
            if (sv1 == null) {
                return sv2 == null ? 0 : -1;
            }
            if (sv2 == null) {
                return 1;
            }
            numeric1 = iter1.isMatching();
            numeric2 = iter2.isMatching();
        } while (!(numeric1 && numeric2 ? (c = (n1 = new BigInteger(sv1.getStringValue())).compareTo(n2 = new BigInteger(sv2.getStringValue()))) != 0 : (c = this.baseCollator.compareStrings(u1 = numeric1 ? EmptyUnicodeString.getInstance() : sv1.getUnicodeStringValue(), u2 = numeric2 ? EmptyUnicodeString.getInstance() : sv2.getUnicodeStringValue())) != 0));
        return c;
    }

    @Override
    public boolean comparesEqual(UnicodeString s1, UnicodeString s2) {
        return this.compareStrings(s1, s2) == 0;
    }

    @Override
    public AtomicMatchKey getCollationKey(UnicodeString cs) {
        StringValue sv;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RegexIterator iter = pattern.analyze(cs);
        while ((sv = iter.next()) != null) {
            byte[] bin;
            if (iter.isMatching()) {
                BigInteger n = new BigInteger(sv.getStringValue());
                bin = n.toByteArray();
                int len = bin.length;
                AlphanumericCollator.writeByte(baos, (byte)0);
                AlphanumericCollator.writeByte(baos, (byte)len);
                baos.write(bin, 0, bin.length);
                continue;
            }
            Base64BinaryValue b64 = CollationKeyFn.getCollationKey(sv.getUnicodeStringValue(), this.baseCollator);
            bin = b64.getBinaryValue();
            baos.write(bin, 0, bin.length);
        }
        return new Base64BinaryValue(baos.toByteArray());
    }

    private static void writeByte(ByteArrayOutputStream baos, byte val) {
        baos.write(val);
    }
}

