/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.EmptySequence;

public class SingletonIterator
implements SequenceIterator,
FocusIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private final Item item;
    private int currentPosition = -1;

    public SingletonIterator(Item value) {
        assert (value != null);
        this.item = value;
    }

    public static SequenceIterator makeIterator(Item item) {
        if (item == null) {
            return EmptyIterator.getInstance();
        }
        return new SingletonIterator(item);
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < 0;
    }

    @Override
    public Item next() {
        return ++this.currentPosition == 0 ? this.item : null;
    }

    @Override
    public Item current() {
        return this.currentPosition == 0 ? this.item : null;
    }

    @Override
    public int position() {
        return this.currentPosition + 1;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }

    @Override
    public SingletonIterator getReverseIterator() {
        return new SingletonIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    @Override
    public GroundedValue materialize() {
        return this.item;
    }

    @Override
    public GroundedValue getResidue() {
        return this.currentPosition < 0 ? this.item : EmptySequence.getInstance();
    }
}

