/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.dfa;

import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.processors.DelimiterIterator;
import org.apache.daffodil.runtime1.processors.dfa.DFA$;
import org.apache.daffodil.runtime1.processors.dfa.DFADelimiter;
import org.apache.daffodil.runtime1.processors.dfa.DelimStateBase;
import org.apache.daffodil.runtime1.processors.dfa.Registers;
import org.apache.daffodil.runtime1.processors.dfa.Rule;
import org.apache.daffodil.runtime1.processors.dfa.State$EndOfDataCharRule$;
import org.apache.daffodil.runtime1.processors.dfa.State$LookAheadEndOfDataCharRule$;
import org.apache.daffodil.runtime1.processors.dfa.State$PauseRule$;
import org.apache.daffodil.runtime1.processors.dfa.State$StartStateRule$;
import org.apache.daffodil.runtime1.processors.dfa.StateKind$;
import org.apache.daffodil.runtime1.processors.dfa.WSPStarState;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public abstract class State
implements Serializable {
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("StartStateRule$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("LookAheadEndOfDataCharRule$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("EndOfDataCharRule$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("PauseRule$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("PTERMState$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("StartState$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("ECState$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(State.class.getDeclaredField("EECState$lzy1"));
    private final State[] states;
    private volatile Object EECState$lzy1;
    private volatile Object ECState$lzy1;
    private volatile Object StartState$lzy1;
    private volatile Object PTERMState$lzy1;
    private volatile Object PauseRule$lzy1;
    private volatile Object EndOfDataCharRule$lzy1;
    private volatile Object LookAheadEndOfDataCharRule$lzy1;
    private volatile Object StartStateRule$lzy1;

    public State(State[] states) {
        this.states = states;
    }

    public abstract int stateNum();

    public abstract String stateName();

    public abstract ArrayBuffer<Rule> rules();

    public void run(Registers r) {
        if (r.state() != this.stateNum()) {
            throw Assert$.MODULE$.abort("Invariant broken: r.state.==(State.this.stateNum)");
        }
        this.runRules(this.rules(), r);
    }

    public final void runRules(ArrayBuffer<Rule> rules, Registers r) {
        while (r.actionNum() < rules.length()) {
            Rule rule = (Rule)rules.apply(r.actionNum());
            boolean useThisRule = rule.test(r);
            if (useThisRule) {
                rule.act(r);
                return;
            }
            r.actionNum_$eq(r.actionNum() + 1);
        }
        r.status_$eq(StateKind$.MODULE$.Failed());
    }

    public int findState(String name) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.states);
        return ((State)ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)st -> {
            String string = st.stateName();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).get()).stateNum();
    }

    public int EECState() {
        Object object = this.EECState$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.EECState$lzyINIT1());
    }

    private Object EECState$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.EECState$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)this.findState("EECState"));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.EECState$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int ECState() {
        Object object = this.ECState$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.ECState$lzyINIT1());
    }

    private Object ECState$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ECState$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)this.findState("ECState"));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ECState$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int StartState() {
        Object object = this.StartState$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.StartState$lzyINIT1());
    }

    private Object StartState$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.StartState$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)this.findState("StartState"));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.StartState$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int PTERMState() {
        Object object = this.PTERMState$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.PTERMState$lzyINIT1());
    }

    private Object PTERMState$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.PTERMState$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)this.findState("PTERM0"));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.PTERMState$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String printStr() {
        return Predef$.MODULE$.wrapRefArray((Object[])this.states).mkString();
    }

    public String toString() {
        return this.stateName() + "_" + this.stateNum();
    }

    public boolean couldBeFirstChar(char charIn, DelimiterIterator delimIter) {
        delimIter.reset();
        while (delimIter.hasNext()) {
            if (!this.couldBeFirstChar(charIn, delimIter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean couldBeFirstChar(char charIn, DFADelimiter d) {
        boolean bl;
        State[] states = d.states();
        State pTerm0 = states[0];
        if (pTerm0 instanceof WSPStarState) {
            WSPStarState wspStar = (WSPStarState)pTerm0;
            if (wspStar.checkMatch(charIn)) {
                bl = true;
            } else {
                if (wspStar.nextState() == DFA$.MODULE$.FinalState()) {
                    throw Assert$.MODULE$.impossibleCase();
                }
                DelimStateBase pTerm1 = (DelimStateBase)states[1];
                bl = pTerm1.checkMatch(charIn);
            }
        } else {
            bl = ((DelimStateBase)pTerm0).checkMatch(charIn);
        }
        boolean res = bl;
        return res;
    }

    public final State$PauseRule$ PauseRule() {
        Object object = this.PauseRule$lzy1;
        if (object instanceof State$PauseRule$) {
            return (State$PauseRule$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (State$PauseRule$)this.PauseRule$lzyINIT1();
    }

    private Object PauseRule$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.PauseRule$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    State$PauseRule$ state$PauseRule$ = null;
                    try {
                        state$PauseRule$ = new State$PauseRule$(this);
                        object2 = state$PauseRule$ == null ? LazyVals.NullValue$.MODULE$ : state$PauseRule$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.PauseRule$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return state$PauseRule$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final State$EndOfDataCharRule$ EndOfDataCharRule() {
        Object object = this.EndOfDataCharRule$lzy1;
        if (object instanceof State$EndOfDataCharRule$) {
            return (State$EndOfDataCharRule$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (State$EndOfDataCharRule$)this.EndOfDataCharRule$lzyINIT1();
    }

    private Object EndOfDataCharRule$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.EndOfDataCharRule$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    State$EndOfDataCharRule$ state$EndOfDataCharRule$ = null;
                    try {
                        state$EndOfDataCharRule$ = new State$EndOfDataCharRule$();
                        object2 = state$EndOfDataCharRule$ == null ? LazyVals.NullValue$.MODULE$ : state$EndOfDataCharRule$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.EndOfDataCharRule$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return state$EndOfDataCharRule$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final State$LookAheadEndOfDataCharRule$ LookAheadEndOfDataCharRule() {
        Object object = this.LookAheadEndOfDataCharRule$lzy1;
        if (object instanceof State$LookAheadEndOfDataCharRule$) {
            return (State$LookAheadEndOfDataCharRule$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (State$LookAheadEndOfDataCharRule$)this.LookAheadEndOfDataCharRule$lzyINIT1();
    }

    private Object LookAheadEndOfDataCharRule$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.LookAheadEndOfDataCharRule$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    State$LookAheadEndOfDataCharRule$ state$LookAheadEndOfDataCharRule$ = null;
                    try {
                        state$LookAheadEndOfDataCharRule$ = new State$LookAheadEndOfDataCharRule$();
                        object2 = state$LookAheadEndOfDataCharRule$ == null ? LazyVals.NullValue$.MODULE$ : state$LookAheadEndOfDataCharRule$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.LookAheadEndOfDataCharRule$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return state$LookAheadEndOfDataCharRule$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final State$StartStateRule$ StartStateRule() {
        Object object = this.StartStateRule$lzy1;
        if (object instanceof State$StartStateRule$) {
            return (State$StartStateRule$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (State$StartStateRule$)this.StartStateRule$lzyINIT1();
    }

    private Object StartStateRule$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.StartStateRule$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    State$StartStateRule$ state$StartStateRule$ = null;
                    try {
                        state$StartStateRule$ = new State$StartStateRule$(this);
                        object2 = state$StartStateRule$ == null ? LazyVals.NullValue$.MODULE$ : state$StartStateRule$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.StartStateRule$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return state$StartStateRule$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

