/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.caching;

import java.util.Collection;
import java.util.Set;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.impl.internal.store.shared.AbstractPartition;
import org.ehcache.impl.internal.store.shared.AbstractSharedTierProvider;
import org.ehcache.impl.internal.store.shared.caching.CachingTierPartition;
import org.ehcache.spi.service.ServiceConfiguration;

public class SharedCachingTierProvider
extends AbstractSharedTierProvider
implements CachingTier.Provider {
    @Override
    public int rankCachingTier(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        return this.rank(CachingTier.class, resourceTypes);
    }

    @Override
    public <K, V> CachingTier<K, V> createCachingTier(Set<ResourceType<?>> resourceTypes, Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        ResourceType.SharedResource<?> resourceType = SharedCachingTierProvider.assertResourceIsShareable(resourceTypes);
        return this.sharedStorageProvider.partition(this.extractAlias(serviceConfigs), resourceType.getResourceType(), storeConfig, (id, store, shared) -> {
            CachingTierPartition partition = new CachingTierPartition(resourceType.getResourceType(), id, store, shared.getInvalidationListeners());
            this.associateStoreStatsWithPartition(store, partition);
            return partition;
        });
    }

    @Override
    public void releaseCachingTier(CachingTier<?, ?> resource) {
        AbstractPartition partition = (AbstractPartition)((Object)resource);
        this.sharedStorageProvider.releasePartition(partition);
    }

    @Override
    public void initCachingTier(CachingTier<?, ?> resource) {
    }
}

