/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.filesystem.impl;

import com.terracottatech.offheapstore.filesystem.SeekableOutputStream;
import com.terracottatech.offheapstore.filesystem.impl.OffheapFile;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OffheapOutputStream
extends SeekableOutputStream {
    private final int BLOCK_SIZE;
    static final ByteBuffer NULL_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final OffheapFile file;
    private ByteBuffer currentBuffer;
    private int currentBufferIndex;
    private int bufferEnd;

    OffheapOutputStream(OffheapFile file, int blockSize) {
        this.BLOCK_SIZE = blockSize;
        this.file = file;
        this.currentBufferIndex = -1;
        this.currentBuffer = NULL_BUFFER;
        this.bufferEnd = -1;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureCapacity();
        this.currentBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            this.ensureCapacity();
            int lenToWrite = Math.min(len, this.currentBuffer.remaining());
            this.currentBuffer.put(b, offset, lenToWrite);
            len -= lenToWrite;
            offset += lenToWrite;
        }
    }

    private void ensureCapacity() throws IOException {
        if (!this.currentBuffer.hasRemaining()) {
            this.flush();
            this.currentBuffer = this.getNextBufferToWrite();
        }
    }

    private ByteBuffer getNextBufferToWrite() {
        this.bufferEnd = -1;
        if (++this.currentBufferIndex < 0) {
            throw new AssertionError((Object)("File size too large to handle : " + this.currentBufferIndex));
        }
        return this.file.getBlockToWrite(this.currentBufferIndex);
    }

    @Override
    public void reset() throws IOException {
        this.currentBuffer = NULL_BUFFER;
        this.currentBufferIndex = -1;
        this.bufferEnd = -1;
        this.file.setLength(0L);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.file.streamClosed(true);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek position cannot be negative");
        }
        long newIndexPos = pos / (long)this.BLOCK_SIZE;
        int bufferPosition = (int)(pos % (long)this.BLOCK_SIZE);
        if (newIndexPos > Integer.MAX_VALUE) {
            throw new AssertionError((Object)("Seek position too large to handle : " + pos + " block size : " + this.BLOCK_SIZE));
        }
        this.flush();
        if ((long)this.currentBufferIndex != newIndexPos) {
            this.currentBufferIndex = (int)newIndexPos;
            this.currentBuffer = this.file.getBlockToWrite(this.currentBufferIndex);
            this.bufferEnd = -1;
        } else {
            this.bufferEnd = Math.max(this.bufferEnd, this.currentBuffer.position());
        }
        this.currentBuffer.position(bufferPosition);
    }

    public String toString() {
        return "Current Buffer : " + this.currentBuffer + " index : " + this.currentBufferIndex + " bufferEnd : " + this.bufferEnd;
    }

    @Override
    public long length() throws IOException {
        this.flush();
        return this.file.length();
    }

    @Override
    public void flush() throws IOException {
        if (this.currentBuffer == NULL_BUFFER) {
            return;
        }
        if (this.bufferEnd != -1 && this.currentBuffer.position() < this.bufferEnd) {
            this.file.flush(this.currentBufferIndex, this.currentBuffer, this.bufferEnd);
        } else {
            this.file.flush(this.currentBufferIndex, this.currentBuffer, this.currentBuffer.position());
        }
        this.bufferEnd = -1;
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : (long)this.currentBufferIndex * (long)this.BLOCK_SIZE + (long)this.currentBuffer.position();
    }

    public long sizeInBytes() {
        return this.file.getSizeInBytes();
    }
}

