/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2js;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.java2js.processor.JavaToJSProcessor;

public class JavaToJS
extends AbstractCXFToolContainer {
    public static final String TOOL_NAME = "java2js";

    public JavaToJS(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean exitOnFinish) {
        JavaToJSProcessor processor = new JavaToJSProcessor();
        try {
            super.execute(exitOnFinish);
            if (!this.hasInfoOption()) {
                ToolContext env = new ToolContext();
                env.setParameters(this.getParametersMap(new HashSet()));
                if (env.get("outputdir") == null) {
                    env.put("outputdir", (Object)".");
                }
                if (this.isVerboseOn()) {
                    env.put("verbose", (Object)Boolean.TRUE);
                }
                env.put("args", (Object)this.getArgument());
                this.validate(env);
                processor.setEnvironment(env);
                processor.process();
            }
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
            }
            this.err.println();
            this.err.println("JavaToJS Error : " + ex.getMessage());
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            }
        }
        catch (Exception ex) {
            this.err.println();
            this.err.println("JavaToJS Error : " + ex.getMessage());
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            }
        }
        finally {
            this.tearDown();
        }
    }

    private void validate(ToolContext env) throws ToolException {
        String outdir = (String)env.get("outputdir");
        if (outdir != null) {
            File dir = new File(outdir);
            if (!dir.exists() && !dir.mkdirs()) {
                Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, new Object[]{outdir});
                throw new ToolException(msg);
            }
            if (!dir.isDirectory()) {
                Message msg = new Message("NOT_A_DIRECTORY", LOG, new Object[]{outdir});
                throw new ToolException(msg);
            }
        }
    }

    public static void main(String[] pargs) {
        System.setProperty("org.apache.cxf.JDKBugHacks.defaultUsesCaches", "true");
        try {
            ToolRunner.runTool(JavaToJS.class, (InputStream)JavaToJS.class.getResourceAsStream("java2js.xml"), (boolean)false, (String[])pargs);
        }
        catch (Exception ex) {
            System.err.println("Java2JS Error : " + ex.getMessage());
            System.err.println();
            ex.printStackTrace();
        }
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        super.checkParams(errors);
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }
}

