/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.search.Beanspector;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public class PrimitiveSearchCondition<T>
implements SearchCondition<T> {
    private String propertyName;
    private Object propertyValue;
    private Type propertyType;
    private T condition;
    private ConditionType cType;
    private Beanspector<T> beanspector;

    public PrimitiveSearchCondition(String propertyName, Object propertyValue, ConditionType ct, T condition) {
        this(propertyName, propertyValue, propertyValue.getClass(), ct, condition);
    }

    public PrimitiveSearchCondition(String propertyName, Object propertyValue, Type propertyType, ConditionType ct, T condition) {
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.propertyType = propertyType;
        this.condition = condition;
        this.cType = ct;
        if (propertyName != null) {
            this.beanspector = SearchBean.class.isAssignableFrom(condition.getClass()) ? null : new Beanspector<T>(condition);
        }
    }

    @Override
    public List<T> findAll(Collection<T> pojos) {
        ArrayList<T> result = new ArrayList<T>();
        for (T pojo : pojos) {
            if (!this.isMet(pojo)) continue;
            result.add(pojo);
        }
        return result;
    }

    @Override
    public T getCondition() {
        return this.condition;
    }

    @Override
    public ConditionType getConditionType() {
        return this.cType;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected Object getPropertyValue() {
        return this.propertyValue;
    }

    protected Type getPropertyType() {
        return this.propertyType;
    }

    @Override
    public List<SearchCondition<T>> getSearchConditions() {
        return null;
    }

    @Override
    public PrimitiveStatement getStatement() {
        return new PrimitiveStatement(this.propertyName, this.propertyValue, this.propertyType, this.cType);
    }

    @Override
    public boolean isMet(T pojo) {
        if (this.isPrimitive(pojo)) {
            return this.compare(pojo, this.cType, this.propertyValue);
        }
        Object lValue = this.getValue(this.propertyName, pojo);
        Object rValue = PrimitiveSearchCondition.getPrimitiveValue(this.propertyName, this.propertyValue);
        return lValue != null && this.compare(lValue, this.cType, rValue);
    }

    private Object getValue(String getter, T pojo) {
        int index = getter.indexOf(46);
        String thePropertyName = index != -1 ? getter.substring(0, index) : getter;
        try {
            Object value = this.beanspector != null ? this.beanspector.swap(pojo).getValue(thePropertyName.toLowerCase()) : ((SearchBean)pojo).get(getter);
            return PrimitiveSearchCondition.getPrimitiveValue(getter, value);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String toSQL(String table, String ... columns) {
        return SearchUtils.toSQL(this, table, columns);
    }

    @Override
    public void accept(SearchConditionVisitor<T, ?> visitor) {
        visitor.visit(this);
    }

    private boolean isPrimitive(T pojo) {
        return pojo.getClass().getName().startsWith("java.lang");
    }

    private boolean compare(Object lval, ConditionType cond, Object rval) {
        boolean compares = true;
        if (cond == ConditionType.EQUALS || cond == ConditionType.NOT_EQUALS) {
            if (rval == null) {
                compares = true;
            } else if (lval == null) {
                compares = false;
            } else {
                compares = lval instanceof String ? this.textCompare((String)lval, (String)rval) : lval.equals(rval);
                if (cond == ConditionType.NOT_EQUALS) {
                    compares = !compares;
                }
            }
        } else if (lval instanceof Comparable && rval instanceof Comparable) {
            Comparable lcomp = (Comparable)lval;
            Comparable rcomp = (Comparable)rval;
            int comp = lcomp.compareTo(rcomp);
            switch (cond) {
                case GREATER_THAN: {
                    compares = comp > 0;
                    break;
                }
                case GREATER_OR_EQUALS: {
                    compares = comp >= 0;
                    break;
                }
                case LESS_THAN: {
                    compares = comp < 0;
                    break;
                }
                case LESS_OR_EQUALS: {
                    compares = comp <= 0;
                    break;
                }
                default: {
                    String msg = String.format("Condition type %s is not supported", cond.name());
                    throw new RuntimeException(msg);
                }
            }
        }
        return compares;
    }

    private boolean textCompare(String lval, String rval) {
        boolean starts = false;
        boolean ends = false;
        if (rval.charAt(0) == '*') {
            starts = true;
            if ((rval = rval.substring(1)).isEmpty()) {
                throw new SearchParseException("A single wildcard is not a valid search condition");
            }
        }
        if (rval.charAt(rval.length() - 1) == '*') {
            ends = true;
            rval = rval.substring(0, rval.length() - 1);
        }
        if (starts || ends) {
            if (starts && !ends) {
                return lval.endsWith(rval);
            }
            if (ends && !starts) {
                return lval.startsWith(rval);
            }
            return lval.contains(rval);
        }
        return lval.equals(rval);
    }

    protected static Object getPrimitiveValue(String name, Object value) {
        int index = name.indexOf(46);
        if (index != -1) {
            String[] names = name.split("\\.");
            name = name.substring(index + 1);
            if (value != null && !InjectionUtils.isPrimitive(value.getClass())) {
                try {
                    String nextPart = StringUtils.capitalize((String)names[1]);
                    Method m = value.getClass().getMethod("get" + nextPart, new Class[0]);
                    value = m.invoke(value, new Object[0]);
                }
                catch (Throwable ex) {
                    throw new RuntimeException();
                }
            }
            return PrimitiveSearchCondition.getPrimitiveValue(name, value);
        }
        return value;
    }
}

