/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import jakarta.jws.Oneway;
import jakarta.xml.bind.annotation.XmlAttachmentRef;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.RequestWrapper;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.ResponseWrapper;

public final class WrapperUtil {
    private WrapperUtil() {
    }

    public static boolean isWrapperClassExists(Method method) {
        RequestWrapper requestWrapper = new RequestWrapper();
        requestWrapper.setMethod(method);
        try {
            requestWrapper.getWrapperClass();
            boolean isOneWay = method.isAnnotationPresent(Oneway.class);
            if (!isOneWay) {
                ResponseWrapper responseWrapper = new ResponseWrapper();
                responseWrapper.setMethod(method);
                responseWrapper.getWrapperClass();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static List<Annotation> getJaxbAnnotations(Method method) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        XmlAttachmentRef ann = method.getAnnotation(XmlAttachmentRef.class);
        if (ann != null) {
            jaxbAnnotation.add((Annotation)ann);
        }
        if ((ann = method.getAnnotation(XmlMimeType.class)) != null) {
            jaxbAnnotation.add((Annotation)ann);
        }
        if ((ann = method.getAnnotation(XmlJavaTypeAdapter.class)) != null) {
            jaxbAnnotation.add((Annotation)ann);
        }
        if ((ann = method.getAnnotation(XmlList.class)) != null) {
            jaxbAnnotation.add((Annotation)ann);
        }
        return jaxbAnnotation;
    }

    public static List<Annotation> getJaxbAnnotations(Method method, int idx) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        Annotation[][] anns = method.getParameterAnnotations();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (i != idx) continue;
            for (Annotation ann : anns[i]) {
                if (ann.annotationType() != XmlAttachmentRef.class && ann.annotationType() != XmlMimeType.class && ann.annotationType() != XmlJavaTypeAdapter.class && ann.annotationType() != XmlList.class && ann.annotationType() != XmlElement.class) continue;
                jaxbAnnotation.add(ann);
            }
        }
        return jaxbAnnotation;
    }
}

