/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.ReusableLatch;

public final class ActiveMQThreadFactory
implements ThreadFactory {
    private String groupName;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final ReusableLatch active = new ReusableLatch(0);
    private final int threadPriority;
    private final boolean daemon;
    private final ClassLoader tccl;
    private final AccessControlContext acc;
    private final String prefix;

    public ActiveMQThreadFactory(String groupName, boolean daemon, ClassLoader tccl) {
        this(groupName, "Thread-", daemon, tccl);
    }

    public ActiveMQThreadFactory(String groupName, String prefix, boolean daemon, ClassLoader tccl) {
        this.groupName = groupName;
        this.prefix = prefix;
        this.threadPriority = 5;
        this.tccl = tccl;
        this.daemon = daemon;
        this.acc = AccessController.getContext();
    }

    @Override
    public Thread newThread(Runnable command) {
        if (this.acc != null) {
            return AccessController.doPrivileged(new ThreadCreateAction(command), this.acc);
        }
        return this.createThread(command);
    }

    public boolean join(int timeout, TimeUnit timeUnit) {
        try {
            return this.active.await(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private Thread createThread(final Runnable command) {
        this.active.countUp();
        Thread t = new Thread(command, this.prefix + this.threadCount.getAndIncrement() + " (" + this.groupName + ")"){

            @Override
            public void run() {
                try {
                    command.run();
                }
                finally {
                    ActiveMQThreadFactory.this.active.countDown();
                }
            }
        };
        t.setDaemon(this.daemon);
        t.setPriority(this.threadPriority);
        if (this.acc != null) {
            AccessController.doPrivileged(() -> {
                t.setContextClassLoader(this.tccl);
                return null;
            });
        } else {
            t.setContextClassLoader(this.tccl);
        }
        return t;
    }

    public static ActiveMQThreadFactory defaultThreadFactory(String callerClassName) {
        return new ActiveMQThreadFactory(callerClassName, false, null);
    }

    private final class ThreadCreateAction
    implements PrivilegedAction<Thread> {
        private final Runnable target;

        private ThreadCreateAction(Runnable target) {
            this.target = target;
        }

        @Override
        public Thread run() {
            return ActiveMQThreadFactory.this.createThread(this.target);
        }
    }
}

