/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.microprofile.client.CxfTypeSafeClientBuilder;
import org.apache.cxf.microprofile.client.config.ConfigFacade;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;

public class RestClientBean
implements Bean<Object>,
PassivationCapable {
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_URI_FORMAT = "%s/mp-rest/uri";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    public static final String REST_PROVIDERS_FORMAT = "%s/mp-rest/providers";
    public static final String REST_CONN_TIMEOUT_FORMAT = "%s/mp-rest/connectTimeout";
    public static final String REST_READ_TIMEOUT_FORMAT = "%s/mp-rest/readTimeout";
    public static final String REST_PROVIDERS_PRIORITY_FORMAT = "/mp-rest/providers/%s/priority";
    public static final String REST_TRUST_STORE_FORMAT = "%s/mp-rest/trustStore";
    public static final String REST_TRUST_STORE_PASSWORD_FORMAT = "%s/mp-rest/trustStorePassword";
    public static final String REST_TRUST_STORE_TYPE_FORMAT = "%s/mp-rest/trustStoreType";
    public static final String REST_HOSTNAME_VERIFIER_FORMAT = "%s/mp-rest/hostnameVerifier";
    public static final String REST_KEY_STORE_FORMAT = "%s/mp-rest/keyStore";
    public static final String REST_KEY_STORE_PASSWORD_FORMAT = "%s/mp-rest/keyStorePassword";
    public static final String REST_KEY_STORE_TYPE_FORMAT = "%s/mp-rest/keyStoreType";
    public static final String REST_FOLLOW_REDIRECTS_FORMAT = "%s/mp-rest/followRedirects";
    public static final String REST_PROXY_ADDRESS_FORMAT = "%s/mp-rest/proxyAddress";
    public static final String QUERY_PARAM_STYLE_FORMAT = "%s/mp-rest/queryParamStyle";
    private static final Logger LOG = LogUtils.getL7dLogger(RestClientBean.class);
    private static final Default DEFAULT_LITERAL = new DefaultLiteral();
    private final Class<?> clientInterface;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    private final Map<Object, CxfTypeSafeClientBuilder> builders = new IdentityHashMap<Object, CxfTypeSafeClientBuilder>();

    public RestClientBean(Class<?> clientInterface, BeanManager beanManager) {
        this.clientInterface = clientInterface;
        this.beanManager = beanManager;
        this.scope = this.readScope();
    }

    public String getId() {
        return this.clientInterface.getName();
    }

    public Class<?> getBeanClass() {
        return this.clientInterface;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        CxfTypeSafeClientBuilder builder = new CxfTypeSafeClientBuilder();
        String baseUri = this.getBaseUri();
        builder = (CxfTypeSafeClientBuilder)builder.baseUri(URI.create(baseUri));
        List<Class<?>> providers = this.getConfiguredProviders();
        Map<Class<?>, Integer> providerPriorities = this.getConfiguredProviderPriorities(providers);
        for (Class<?> providerClass : providers) {
            builder = (CxfTypeSafeClientBuilder)builder.register(providerClass, (int)providerPriorities.getOrDefault(providerClass, 5000));
        }
        this.setTimeouts(builder);
        this.setSSLConfig(builder);
        this.setFollowRedirects(builder);
        this.setProxyAddress(builder);
        this.setQueryParamStyle(builder);
        Object clientInstance = builder.build(this.clientInterface);
        this.builders.put(clientInstance, builder);
        return clientInstance;
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        CxfTypeSafeClientBuilder builder = this.builders.remove(instance);
        if (builder != null) {
            builder.close();
        }
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.clientInterface);
    }

    public Set<Annotation> getQualifiers() {
        return new HashSet<Annotation>(Arrays.asList(DEFAULT_LITERAL, RestClient.RestClientLiteral.LITERAL));
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.clientInterface.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    private String getBaseUri() {
        String annoUri;
        RegisterRestClient anno;
        String interfaceName = this.clientInterface.getName();
        String baseURI = ConfigFacade.getOptionalValue(REST_URI_FORMAT, this.clientInterface, String.class).orElseGet(() -> ConfigFacade.getOptionalValue(REST_URL_FORMAT, this.clientInterface, String.class).orElse(null));
        if (baseURI == null && (anno = this.clientInterface.getAnnotation(RegisterRestClient.class)) != null && (annoUri = anno.baseUri()) != null && !"".equals(anno.baseUri())) {
            baseURI = annoUri;
        }
        if (baseURI == null) {
            throw new IllegalStateException("Unable to determine base URI from configuration for " + interfaceName);
        }
        return baseURI;
    }

    private Class<? extends Annotation> readScope() {
        Annotation[] annotations;
        String configuredScope = ConfigFacade.getOptionalValue(REST_SCOPE_FORMAT, this.clientInterface, String.class).orElse(null);
        if (configuredScope != null) {
            try {
                return ClassLoaderUtils.loadClass((String)configuredScope, this.getClass(), Annotation.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The scope " + configuredScope + " is invalid", e);
            }
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.clientInterface.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        throw new IllegalArgumentException("The client interface " + String.valueOf(this.clientInterface) + " has multiple scopes defined " + String.valueOf(possibleScopes));
    }

    List<Class<?>> getConfiguredProviders() {
        String providersList = ConfigFacade.getOptionalValue(REST_PROVIDERS_FORMAT, this.clientInterface, String.class).orElse(null);
        ArrayList providers = new ArrayList();
        if (providersList != null) {
            String[] providerClassNames = providersList.split(",");
            for (int i = 0; i < providerClassNames.length; ++i) {
                try {
                    providers.add(ClassLoaderUtils.loadClass((String)providerClassNames[i], RestClientBean.class));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LOG.log(Level.WARNING, "Could not load provider, {0}, configured for Rest Client interface, {1} ", new Object[]{providerClassNames[i], this.clientInterface.getName()});
                }
            }
        }
        return providers;
    }

    Map<Class<?>, Integer> getConfiguredProviderPriorities(List<Class<?>> providers) {
        HashMap map = new HashMap();
        for (Class<?> providerClass : providers) {
            String propertyFormat = "%s" + String.format(REST_PROVIDERS_PRIORITY_FORMAT, providerClass.getName());
            Integer priority = ConfigFacade.getOptionalValue(propertyFormat, this.clientInterface, Integer.class).orElse(RestClientBean.getPriorityFromClass(providerClass, 5000));
            map.put(providerClass, priority);
        }
        return map;
    }

    private static int getPriorityFromClass(Class<?> providerClass, int defaultValue) {
        Priority p = providerClass.getAnnotation(Priority.class);
        return p != null ? p.value() : defaultValue;
    }

    private void setTimeouts(CxfTypeSafeClientBuilder builder) {
        ConfigFacade.getOptionalLong(REST_CONN_TIMEOUT_FORMAT, this.clientInterface).ifPresent(timeoutValue -> {
            builder.connectTimeout(timeoutValue, TimeUnit.MILLISECONDS);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("readTimeout set by MP Config: " + timeoutValue);
            }
        });
        ConfigFacade.getOptionalLong(REST_READ_TIMEOUT_FORMAT, this.clientInterface).ifPresent(timeoutValue -> {
            builder.readTimeout(timeoutValue, TimeUnit.MILLISECONDS);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("readTimeout set by MP Config: " + timeoutValue);
            }
        });
    }

    private void setFollowRedirects(CxfTypeSafeClientBuilder builder) {
        ConfigFacade.getOptionalValue(REST_FOLLOW_REDIRECTS_FORMAT, this.clientInterface, String.class).ifPresent(follows -> {
            builder.followRedirects(PropertyUtils.isTrue((Object)follows));
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("followRedirect set by MP Config: " + follows);
            }
        });
    }

    private void setProxyAddress(CxfTypeSafeClientBuilder builder) {
        ConfigFacade.getOptionalValue(REST_PROXY_ADDRESS_FORMAT, this.clientInterface, String.class).ifPresent(address -> {
            String[] split = address.split(":");
            if (split.length != 2) {
                throw new IllegalStateException(String.format("Invalid proxy server address configured for %s: %s", this.clientInterface.getName(), address));
            }
            try {
                String hostname = split[0];
                int port = Integer.parseInt(split[1]);
                builder.proxyAddress(hostname, port);
            }
            catch (Throwable t) {
                throw new IllegalStateException(String.format("Invalid proxy server address configured for %s: %s", this.clientInterface.getName(), address), t);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("proxyAddress set by MP Config: " + address);
            }
        });
    }

    private void setQueryParamStyle(CxfTypeSafeClientBuilder builder) {
        ConfigFacade.getOptionalValue(QUERY_PARAM_STYLE_FORMAT, this.clientInterface, String.class).ifPresent(styleString -> {
            try {
                builder.queryParamStyle(QueryParamStyle.valueOf((String)styleString));
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("queryParamStyle set by MP Config: " + styleString);
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException(String.format("Invalid queryParamStyle value specified for %s: %s", this.clientInterface.getName(), styleString));
            }
        });
    }

    private void setSSLConfig(CxfTypeSafeClientBuilder builder) {
        ConfigFacade.getOptionalValue(REST_HOSTNAME_VERIFIER_FORMAT, this.clientInterface, String.class).ifPresent(className -> {
            try {
                Class clazz = ClassLoaderUtils.loadClassFromContextLoader((String)className);
                Constructor ctor = ReflectionUtil.getConstructor((Class)clazz, (Class[])new Class[0]);
                if (ctor != null) {
                    builder.hostnameVerifier((HostnameVerifier)ctor.newInstance(new Object[0]));
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOG.log(Level.WARNING, "INVALID_HOSTNAME_VERIFIER_CONFIGURED", new Object[]{className, this.clientInterface.getName()});
        });
        ConfigFacade.getOptionalValue(REST_TRUST_STORE_FORMAT, this.clientInterface, String.class).ifPresent(trustStoreLoc -> this.initTrustStore((String)trustStoreLoc, builder));
        ConfigFacade.getOptionalValue(REST_KEY_STORE_FORMAT, this.clientInterface, String.class).ifPresent(keyStoreLoc -> this.initKeyStore((String)keyStoreLoc, builder));
    }

    private void initTrustStore(String trustStoreLoc, CxfTypeSafeClientBuilder builder) {
        String password = ConfigFacade.getOptionalValue(REST_TRUST_STORE_PASSWORD_FORMAT, this.clientInterface, String.class).orElse(null);
        String storeType = ConfigFacade.getOptionalValue(REST_TRUST_STORE_TYPE_FORMAT, this.clientInterface, String.class).orElse("JKS");
        try {
            KeyStore trustStore = KeyStore.getInstance(storeType);
            try (InputStream input = this.getInputStream(trustStoreLoc);){
                trustStore.load(input, password == null ? null : password.toCharArray());
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Failed to initialize trust store from URL, " + trustStoreLoc, t);
            }
            builder.trustStore(trustStore);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + trustStoreLoc, e);
        }
    }

    private void initKeyStore(String keyStoreLoc, CxfTypeSafeClientBuilder builder) {
        String password = ConfigFacade.getOptionalValue(REST_KEY_STORE_PASSWORD_FORMAT, this.clientInterface, String.class).orElse(null);
        String storeType = ConfigFacade.getOptionalValue(REST_KEY_STORE_TYPE_FORMAT, this.clientInterface, String.class).orElse("JKS");
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType);
            try (InputStream input = this.getInputStream(keyStoreLoc);){
                keyStore.load(input, password == null ? null : password.toCharArray());
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Failed to initialize key store from URL, " + keyStoreLoc, t);
            }
            builder.keyStore(keyStore, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize key store from " + keyStoreLoc, e);
        }
    }

    InputStream getInputStream(String location) {
        if (location.startsWith("classpath:")) {
            List urls = ClassLoaderUtils.getResources((String)(location = location.substring(10)), this.clientInterface);
            if (urls != null && !urls.isEmpty()) {
                try {
                    return ((URL)urls.get(0)).openStream();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            LOG.warning("could not find classpath:" + location);
            throw new IllegalStateException("could not find configured key/trust store: " + location);
        }
        try {
            return new URL(location).openStream();
        }
        catch (Exception e) {
            try {
                return new URL("file:" + location).openStream();
            }
            catch (Exception exception) {
                throw new IllegalStateException("could not find configured key/trust store URL: " + location);
            }
        }
    }

    private static final class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;

        private DefaultLiteral() {
        }
    }
}

