/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.encryption.DerivedKey;
import org.opensaml.xmlsec.encryption.DerivedKeyName;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.encryption.MasterKeyName;
import org.opensaml.xmlsec.encryption.ReferenceList;
import org.opensaml.xmlsec.encryption.impl.AbstractXMLEncryptionUnmarshaller;
import org.w3c.dom.Attr;

public class DerivedKeyUnmarshaller
extends AbstractXMLEncryptionUnmarshaller {
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
        DerivedKey dk = (DerivedKey)xmlObject;
        if (attribute.getLocalName().equals("Id")) {
            dk.setId(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        } else if (attribute.getLocalName().equals("Recipient")) {
            dk.setRecipient(attribute.getValue());
        } else if (attribute.getLocalName().equals("Type")) {
            dk.setType(attribute.getValue());
        } else {
            super.processAttribute(xmlObject, attribute);
        }
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
        DerivedKey dk = (DerivedKey)parentXMLObject;
        if (childXMLObject instanceof KeyDerivationMethod) {
            dk.setKeyDerivationMethod((KeyDerivationMethod)childXMLObject);
        } else if (childXMLObject instanceof ReferenceList) {
            dk.setReferenceList((ReferenceList)childXMLObject);
        } else if (childXMLObject instanceof DerivedKeyName) {
            dk.setDerivedKeyName((DerivedKeyName)childXMLObject);
        } else if (childXMLObject instanceof MasterKeyName) {
            dk.setMasterKeyName((MasterKeyName)childXMLObject);
        } else {
            super.processChildElement(parentXMLObject, childXMLObject);
        }
    }
}

