/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaType;

public class WebParamAnnotator
implements Annotator {
    boolean forceHeader;

    public WebParamAnnotator() {
    }

    public WebParamAnnotator(boolean head) {
        this.forceHeader = head;
    }

    public void annotate(JavaAnnotatable ja) {
        JavaParameter paramInList;
        if (!(ja instanceof JavaParameter)) {
            throw new RuntimeException("WebParamAnnotator only annotate the JavaParameter");
        }
        JavaParameter parameter = (JavaParameter)ja;
        JavaMethod method = parameter.getMethod();
        if (method.hasParameter(parameter.getName()) && (paramInList = method.getParameter(parameter.getName())).isIN() && parameter.isOUT()) {
            parameter.setStyle(JavaType.Style.INOUT);
        }
        JAnnotation webParamAnnotation = new JAnnotation(WebParam.class);
        String name = parameter.getName();
        String targetNamespace = method.getInterface().getNamespace();
        String partName = null;
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT || parameter.isHeader()) {
            targetNamespace = parameter.getTargetNamespace();
            if (parameter.getQName() != null) {
                name = parameter.getQName().getLocalPart();
            }
            if (!method.isWrapperStyle()) {
                partName = parameter.getPartName();
            }
        }
        if (method.getSoapStyle() == SOAPBinding.Style.RPC) {
            name = parameter.getPartName();
            partName = parameter.getPartName();
        }
        if (partName != null) {
            webParamAnnotation.addElement(new JAnnotationElement("partName", (Object)partName));
        }
        if (parameter.getStyle() == JavaType.Style.OUT) {
            webParamAnnotation.addElement(new JAnnotationElement("mode", (Object)WebParam.Mode.OUT));
        } else if (parameter.getStyle() == JavaType.Style.INOUT) {
            webParamAnnotation.addElement(new JAnnotationElement("mode", (Object)WebParam.Mode.INOUT));
        }
        webParamAnnotation.addElement(new JAnnotationElement("name", (Object)name));
        if (null != targetNamespace && (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT || parameter.isHeader())) {
            webParamAnnotation.addElement(new JAnnotationElement("targetNamespace", (Object)targetNamespace));
        }
        for (String importClz : webParamAnnotation.getImports()) {
            parameter.getMethod().getInterface().addImport(importClz);
        }
        if (this.forceHeader) {
            webParamAnnotation.addElement(new JAnnotationElement("header", (Object)true, true));
        }
        parameter.addAnnotation("WebParam", webParamAnnotation);
    }
}

