/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.buffer.CircularByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CircularByteBufferTest {
    CircularByteBufferTest() {
    }

    @Test
    void testAddByteSmallestBuffer() {
        CircularByteBuffer cbb = new CircularByteBuffer(1);
        cbb.add((byte)1);
        Assertions.assertEquals((int)1, (int)cbb.read());
        cbb.add((byte)2);
        Assertions.assertEquals((int)2, (int)cbb.read());
    }

    @Test
    void testAddInvalidOffset() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.add(new byte[]{1, 2, 3}, -1, 3));
    }

    @Test
    void testAddNegativeLength() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        byte[] targetBuffer = new byte[]{1, 2, 3};
        Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.add(targetBuffer, 0, -1));
    }

    @Test
    void testAddNullBuffer() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        Assertions.assertThrows(NullPointerException.class, () -> cbb.add(null, 0, 3));
    }

    @Test
    void testAddValidData() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        int length = 3;
        cbb.add(new byte[]{3, 6, 9}, 0, 3);
        Assertions.assertEquals((int)3, (int)cbb.getCurrentNumberOfBytes());
    }

    @Test
    void testClear() {
        byte[] data = new byte[]{1, 2, 3};
        CircularByteBuffer buffer = new CircularByteBuffer(10);
        Assertions.assertEquals((int)0, (int)buffer.getCurrentNumberOfBytes());
        Assertions.assertFalse((boolean)buffer.hasBytes());
        buffer.add(data, 0, data.length);
        Assertions.assertEquals((int)3, (int)buffer.getCurrentNumberOfBytes());
        Assertions.assertEquals((int)7, (int)buffer.getSpace());
        Assertions.assertTrue((boolean)buffer.hasBytes());
        Assertions.assertTrue((boolean)buffer.hasSpace());
        buffer.clear();
        Assertions.assertEquals((int)0, (int)buffer.getCurrentNumberOfBytes());
        Assertions.assertEquals((int)10, (int)buffer.getSpace());
        Assertions.assertFalse((boolean)buffer.hasBytes());
        Assertions.assertTrue((boolean)buffer.hasSpace());
    }

    @Test
    void testHasSpace() {
        CircularByteBuffer cbb = new CircularByteBuffer(1);
        Assertions.assertTrue((boolean)cbb.hasSpace());
        cbb.add((byte)1);
        Assertions.assertFalse((boolean)cbb.hasSpace());
        Assertions.assertEquals((int)1, (int)cbb.read());
        Assertions.assertTrue((boolean)cbb.hasSpace());
        cbb.add((byte)2);
        Assertions.assertFalse((boolean)cbb.hasSpace());
        Assertions.assertEquals((int)2, (int)cbb.read());
        Assertions.assertTrue((boolean)cbb.hasSpace());
    }

    @Test
    void testHasSpaceInt() {
        CircularByteBuffer cbb = new CircularByteBuffer(1);
        Assertions.assertTrue((boolean)cbb.hasSpace(1));
        cbb.add((byte)1);
        Assertions.assertFalse((boolean)cbb.hasSpace(1));
        Assertions.assertEquals((int)1, (int)cbb.read());
        Assertions.assertTrue((boolean)cbb.hasSpace(1));
        cbb.add((byte)2);
        Assertions.assertFalse((boolean)cbb.hasSpace(1));
        Assertions.assertEquals((int)2, (int)cbb.read());
        Assertions.assertTrue((boolean)cbb.hasSpace(1));
    }

    @Test
    void testPeekWithExcessiveLength() {
        Assertions.assertFalse((boolean)new CircularByteBuffer().peek(new byte[]{1, 3, 5, 7, 9}, 0, 6));
    }

    @Test
    void testPeekWithInvalidOffset() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.peek(new byte[]{2, 4, 6, 8, 10}, -1, 5));
        Assertions.assertEquals((Object)"Illegal offset: -1", (Object)e.getMessage());
    }

    @Test
    void testPeekWithNegativeLength() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.peek(new byte[]{1, 4, 3}, 0, -1));
        Assertions.assertEquals((Object)"Illegal length: -1", (Object)e.getMessage());
    }

    @Test
    void testPeekWithValidArguments() {
        Assertions.assertFalse((boolean)new CircularByteBuffer().peek(new byte[]{5, 10, 15, 20, 25}, 0, 5));
    }

    @Test
    void testReadByteArray() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        String string = "0123456789";
        byte[] bytesIn = "0123456789".getBytes(StandardCharsets.UTF_8);
        cbb.add(bytesIn, 0, 10);
        byte[] bytesOut = new byte[10];
        cbb.read(bytesOut, 0, 10);
        Assertions.assertEquals((Object)"0123456789", (Object)new String(bytesOut, StandardCharsets.UTF_8));
    }

    @Test
    void testReadByteArrayIllegalArgumentException() {
        CircularByteBuffer cbb = new CircularByteBuffer();
        byte[] bytesOut = new byte[10];
        Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.read(bytesOut, -1, 10));
        Assertions.assertThrows(IllegalArgumentException.class, () -> cbb.read(bytesOut, 0, bytesOut.length + 1));
    }
}

