/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IORandomAccessFile;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.build.AbstractOriginTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class IORandomAccessFileTest {
    protected static final String FILE_NAME_RW = "target/" + AbstractOriginTest.class.getSimpleName() + ".txt";

    IORandomAccessFileTest() {
    }

    private File newFileFixture() throws IOException {
        File file = new File(FILE_NAME_RW);
        FileUtils.touch((File)file);
        return file;
    }

    @ParameterizedTest
    @EnumSource(value=RandomAccessFileMode.class)
    void testFile(RandomAccessFileMode mode) throws IOException {
        File file = this.newFileFixture();
        String modeStr = mode.getMode();
        try (IORandomAccessFile raf = new IORandomAccessFile(file, modeStr);){
            Assertions.assertEquals((Object)file, (Object)raf.getFile());
            Assertions.assertEquals((Object)modeStr, (Object)raf.getMode());
        }
    }

    @ParameterizedTest
    @EnumSource(value=RandomAccessFileMode.class)
    void testString(RandomAccessFileMode mode) throws IOException {
        File file = this.newFileFixture();
        String modeStr = mode.getMode();
        try (IORandomAccessFile raf = new IORandomAccessFile(FILE_NAME_RW, modeStr);){
            Assertions.assertEquals((Object)file, (Object)raf.getFile());
            Assertions.assertEquals((Object)modeStr, (Object)raf.getMode());
        }
    }

    @Test
    void testToString() throws IOException {
        File file = this.newFileFixture();
        try (IORandomAccessFile raf = new IORandomAccessFile(FILE_NAME_RW, "r");){
            Assertions.assertEquals((Object)file.toString(), (Object)raf.toString());
        }
    }
}

