/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.web;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.web.JakartaServletFilterConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJakartaServletFilterConfiguration
extends TestAbstractConfiguration {
    @Override
    protected AbstractConfiguration getConfiguration() {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("key1", "value1");
        config.setInitParameter("key2", "value2");
        config.setInitParameter("list", "value1, value2");
        config.setInitParameter("listesc", "value1\\,value2");
        JakartaServletFilterConfiguration resultConfig = new JakartaServletFilterConfiguration((FilterConfig)config);
        resultConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return resultConfig;
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        return new JakartaServletFilterConfiguration((FilterConfig)new MockFilterConfig());
    }

    @Override
    @Test
    public void testAddPropertyDirect() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testAddPropertyDirect());
    }

    @Override
    @Test
    public void testClearProperty() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testClearProperty());
    }

    @Override
    @Test
    public void testContainsValue() {
        Assertions.assertFalse((boolean)this.getConfiguration().containsValue(null));
        Assertions.assertFalse((boolean)this.getConfiguration().containsValue((Object)""));
    }

    private static final class MockFilterConfig
    implements FilterConfig {
        private final Properties parameters = new Properties();

        private MockFilterConfig() {
        }

        public String getFilterName() {
            return null;
        }

        public String getInitParameter(String key) {
            return this.parameters.getProperty(key);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.parameters.keys();
        }

        public ServletContext getServletContext() {
            return null;
        }

        public void setInitParameter(String key, String value) {
            this.parameters.setProperty(key, value);
        }
    }
}

