/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.InMemoryNodeModelSupport;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.TrackedNodeModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestTrackedNodeModel {
    private static final String KEY = "aTestKey";
    private static NodeSelector selector;
    private static NodeKeyResolver<ImmutableNode> resolver;
    private InMemoryNodeModel parentModel;
    private InMemoryNodeModelSupport modelSupport;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        NodeKeyResolver resolverMock;
        selector = new NodeSelector("someKey");
        resolver = resolverMock = (NodeKeyResolver)Mockito.mock(NodeKeyResolver.class);
    }

    private NodeHandler<ImmutableNode> prepareGetNodeHandler() {
        NodeHandler handler = (NodeHandler)Mockito.mock(NodeHandler.class);
        Mockito.when((Object)this.parentModel.getTrackedNodeHandler(selector)).thenReturn((Object)handler);
        return handler;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.parentModel = (InMemoryNodeModel)Mockito.mock(InMemoryNodeModel.class);
        this.modelSupport = (InMemoryNodeModelSupport)Mockito.mock(InMemoryNodeModelSupport.class);
        Mockito.when((Object)this.modelSupport.getNodeModel()).thenReturn((Object)this.parentModel);
    }

    private TrackedNodeModel setUpModel() {
        return new TrackedNodeModel(this.modelSupport, selector, true);
    }

    @Test
    void testAddNodes() {
        List<ImmutableNode> nodes = Arrays.asList(NodeStructureHelper.createNode("n1", 1), NodeStructureHelper.createNode("n2", 2));
        this.setUpModel().addNodes(KEY, nodes, resolver);
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).addNodes(KEY, selector, nodes, resolver);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testAddProperty() {
        Iterable values = (Iterable)Mockito.mock(Iterable.class);
        this.setUpModel().addProperty(KEY, values, resolver);
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).addProperty(KEY, selector, values, resolver);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testClear() {
        Mockito.when((Object)this.parentModel.clearTree(null, selector, resolver)).thenReturn(null);
        this.setUpModel().clear(resolver);
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).clearTree(null, selector, resolver);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testClearProperty() {
        this.setUpModel().clearProperty(KEY, resolver);
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).clearProperty(KEY, selector, resolver);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testClearTree() {
        QueryResult result = QueryResult.createNodeResult((Object)NodeStructureHelper.createNode("test", null));
        List<QueryResult> removed = Collections.singletonList(result);
        Mockito.when((Object)this.parentModel.clearTree(KEY, selector, resolver)).thenReturn(removed);
        Assertions.assertSame(removed, (Object)this.setUpModel().clearTree(KEY, resolver));
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).clearTree(KEY, selector, resolver);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testClose() {
        this.setUpModel().close();
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).untrackNode(selector);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testCloseMultipleTimes() {
        TrackedNodeModel model = this.setUpModel();
        model.close();
        model.close();
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).untrackNode(selector);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testGetInMemoryRepresentation() {
        NodeHandler<ImmutableNode> handler = this.prepareGetNodeHandler();
        ImmutableNode root = NodeStructureHelper.createNode("Root", null);
        Mockito.when((Object)((ImmutableNode)handler.getRootNode())).thenReturn((Object)root);
        TrackedNodeModel model = this.setUpModel();
        Assertions.assertSame((Object)root, (Object)model.getInMemoryRepresentation());
    }

    @Test
    void testGetNodeHandler() {
        NodeHandler<ImmutableNode> handler = this.prepareGetNodeHandler();
        Assertions.assertSame(handler, (Object)this.setUpModel().getNodeHandler());
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).getTrackedNodeHandler(selector);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testInitNoParentModel() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TrackedNodeModel(null, selector, true));
    }

    @Test
    void testInitNoSelector() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TrackedNodeModel(this.modelSupport, null, true));
    }

    @Test
    void testSetProperty() {
        Integer value = 42;
        this.setUpModel().setProperty(KEY, (Object)value, resolver);
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).setProperty(KEY, selector, (Object)value, resolver);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }

    @Test
    void testSetRootNode() {
        ImmutableNode root = NodeStructureHelper.createNode("root", null);
        TrackedNodeModel model = this.setUpModel();
        model.setRootNode(root);
        ((InMemoryNodeModel)Mockito.verify((Object)this.parentModel)).replaceTrackedNode(selector, root);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.parentModel});
    }
}

