/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.beans.beancontext.BeanContextServicesSupport;
import java.beans.beancontext.BeanContextSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Properties;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.DataConfiguration;
import org.apache.commons.configuration2.FileURLStreamHandler;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.DefaultFileSystem;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestPropertiesConfiguration {
    private static final String PROP_NAME = "testProperty";
    private static final String PROP_VALUE = "value";
    private static final String CR = System.lineSeparator();
    private static final String TEST_PROPERTIES = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
    private static final String TEST_BASE_PATH = ConfigurationAssert.TEST_DIR.getAbsolutePath();
    private static final String TEST_BASE_PATH_2 = ConfigurationAssert.TEST_DIR.getParentFile().getAbsolutePath();
    private static final File TEST_SAVE_PROPERTIES_FILE = ConfigurationAssert.getOutFile("testsave.properties");
    private PropertiesConfiguration conf;
    @TempDir
    public File tempFolder;

    private static FileHandler load(PropertiesConfiguration pc, String fileName) throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setFileName(fileName);
        handler.load();
        return handler;
    }

    private void checkBackslashList(String key) {
        Object prop = this.conf.getProperty("test." + key);
        List list = (List)Assertions.assertInstanceOf(List.class, (Object)prop);
        String prefix = "\\\\" + key;
        Assertions.assertEquals(Arrays.asList(prefix + "a", prefix + "b"), (Object)list);
    }

    private void checkCopiedConfig(Configuration copyConf) throws ConfigurationException {
        this.saveTestConfig();
        PropertiesConfiguration checkConf = new PropertiesConfiguration();
        TestPropertiesConfiguration.load(checkConf, TEST_SAVE_PROPERTIES_FILE.getAbsolutePath());
        Iterator it = copyConf.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assertions.assertEquals((Object)checkConf.getProperty(key), (Object)copyConf.getProperty(key), (String)("Wrong value for property " + key));
        }
    }

    private void checkEmpty(String key) {
        String empty = this.conf.getString(key);
        Assertions.assertNotNull((Object)empty, (String)("Property not found: " + key));
        Assertions.assertEquals((Object)"", (Object)empty, (String)("Wrong value for property " + key));
    }

    private PropertiesConfiguration checkSavedConfig() throws ConfigurationException {
        PropertiesConfiguration checkConfig = new PropertiesConfiguration();
        checkConfig.setListDelimiterHandler((ListDelimiterHandler)new LegacyListDelimiterHandler(','));
        TestPropertiesConfiguration.load(checkConfig, TEST_SAVE_PROPERTIES_FILE.getAbsolutePath());
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)checkConfig);
        return checkConfig;
    }

    private void saveTestConfig() throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.save(TEST_SAVE_PROPERTIES_FILE);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new PropertiesConfiguration();
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new LegacyListDelimiterHandler(','));
        TestPropertiesConfiguration.load(this.conf, TEST_PROPERTIES);
        if (TEST_SAVE_PROPERTIES_FILE.exists()) {
            Assertions.assertTrue((boolean)TEST_SAVE_PROPERTIES_FILE.delete());
        }
    }

    private Configuration setUpCopyConfig() {
        int count = 25;
        BaseConfiguration result = new BaseConfiguration();
        for (int i = 1; i <= 25; ++i) {
            result.addProperty("copyKey" + i, (Object)("copyValue" + i));
        }
        return result;
    }

    @Test
    void testAppend() throws Exception {
        File file2 = ConfigurationAssert.getTestFile("threesome.properties");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load(file2);
        Assertions.assertEquals((Object)"aaa", (Object)this.conf.getString("test.threesome.one"));
        Assertions.assertEquals((Object)"true", (Object)this.conf.getString("configuration.loaded"));
    }

    @Test
    void testAppendAndSave() throws ConfigurationException {
        Configuration copyConf = this.setUpCopyConfig();
        this.conf.append(copyConf);
        this.checkCopiedConfig(copyConf);
    }

    @Test
    void testBackslashEscapingInLists() throws Exception {
        this.checkBackslashList("share2");
        this.checkBackslashList("share1");
    }

    @Test
    void testChangingListDelimiter() throws Exception {
        Assertions.assertEquals((Object)"a^b^c", (Object)this.conf.getString("test.other.delimiter"));
        PropertiesConfiguration pc2 = new PropertiesConfiguration();
        pc2.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler('^'));
        TestPropertiesConfiguration.load(pc2, TEST_PROPERTIES);
        Assertions.assertEquals((Object)"a", (Object)pc2.getString("test.other.delimiter"));
        Assertions.assertEquals((int)3, (int)pc2.getList("test.other.delimiter").size());
    }

    @Test
    void testClearFooterComment() {
        this.conf.clear();
        Assertions.assertNull((Object)this.conf.getFooter());
        Assertions.assertNull((Object)this.conf.getHeader());
    }

    @Test
    void testClone() throws ConfigurationException {
        PropertiesConfiguration copy = (PropertiesConfiguration)this.conf.clone();
        Assertions.assertNotSame((Object)this.conf.getLayout(), (Object)copy.getLayout());
        Assertions.assertEquals((int)1, (int)this.conf.getEventListeners(ConfigurationEvent.ANY).size());
        Assertions.assertEquals((int)1, (int)copy.getEventListeners(ConfigurationEvent.ANY).size());
        Assertions.assertSame((Object)this.conf.getLayout(), this.conf.getEventListeners(ConfigurationEvent.ANY).iterator().next());
        Assertions.assertSame((Object)copy.getLayout(), copy.getEventListeners(ConfigurationEvent.ANY).iterator().next());
        StringWriter outConf = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)outConf);
        StringWriter outCopy = new StringWriter();
        new FileHandler((FileBased)copy).save((Writer)outCopy);
        Assertions.assertEquals((Object)outConf.toString(), (Object)outCopy.toString());
    }

    @Test
    void testCloneNullLayout() {
        this.conf = new PropertiesConfiguration();
        PropertiesConfiguration copy = (PropertiesConfiguration)this.conf.clone();
        Assertions.assertNotSame((Object)this.conf.getLayout(), (Object)copy.getLayout());
    }

    @Test
    void testComment() {
        Assertions.assertFalse((boolean)this.conf.containsKey("#comment"));
        Assertions.assertFalse((boolean)this.conf.containsKey("!comment"));
    }

    private Collection<?> testCompress840(Iterable<?> object) {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        ListDelimiterHandler listDelimiterHandler = configuration.getListDelimiterHandler();
        listDelimiterHandler.flatten(object, 0);
        listDelimiterHandler.flatten(object, 1);
        listDelimiterHandler.flatten(object, Integer.MAX_VALUE);
        listDelimiterHandler.parse(object);
        configuration.addProperty("foo", object);
        configuration.toString();
        return listDelimiterHandler.flatten(object, Integer.MAX_VALUE);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 2, 4, 8, 16})
    void testCompress840ArrayList(int size) {
        ArrayList<Integer> object = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            object.add(i);
        }
        Collection<?> result = this.testCompress840(object);
        Assertions.assertNotNull(result);
        Assertions.assertEquals((int)size, (int)result.size());
        Assertions.assertEquals(object, result);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 2, 4, 8, 16})
    void testCompress840ArrayListCycle(int size) {
        ArrayList<Serializable> object = new ArrayList<Serializable>();
        for (int i = 0; i < size; ++i) {
            object.add(Integer.valueOf(i));
            object.add(object);
            object.add(new ArrayList(object));
        }
        Collection<?> result = this.testCompress840(object);
        Assertions.assertNotNull(result);
        Assertions.assertEquals((int)size, (int)result.size());
        object.add(object);
        this.testCompress840(object);
    }

    @Test
    void testCompress840BeanContextServicesSupport() {
        this.testCompress840(new BeanContextServicesSupport());
        this.testCompress840(new BeanContextServicesSupport(new BeanContextServicesSupport()));
        BeanContextSupport bcs = new BeanContextSupport();
        BeanContextServicesSupport bcss = new BeanContextServicesSupport();
        bcs.add(FileSystems.getDefault().getPath("bar", new String[0]));
        bcss.add(bcs);
        this.testCompress840(bcss);
        bcss.add(FileSystems.getDefault().getPath("bar", new String[0]));
        this.testCompress840(bcss);
        bcss.add(bcss);
        this.testCompress840(bcss);
    }

    @Test
    void testCompress840BeanContextSupport() {
        this.testCompress840(new BeanContextSupport());
        this.testCompress840(new BeanContextSupport(new BeanContextSupport()));
        BeanContextSupport bcs = new BeanContextSupport();
        bcs.add(FileSystems.getDefault().getPath("bar", new String[0]));
        this.testCompress840(bcs);
        bcs.add(bcs);
        this.testCompress840(bcs);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 2, 4, 8, 16})
    void testCompress840Exception(int size) {
        ArrayList<Serializable> object = new ArrayList<Serializable>();
        Exception bottom = new Exception();
        object.add(bottom);
        Exception top = bottom;
        for (int i = 0; i < size; ++i) {
            object.add(Integer.valueOf(i));
            top = new Exception(top);
            object.add(top);
        }
        if (bottom != top) {
            bottom.initCause(top);
        }
        Collection<?> result = this.testCompress840(object);
        Assertions.assertNotNull(result);
        Assertions.assertEquals((int)(size * 2 + 1), (int)result.size());
        Assertions.assertEquals(object, result);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 2, 4, 8, 16})
    void testCompress840Path(int size) {
        PriorityQueue<Path> object = new PriorityQueue<Path>();
        for (int i = 0; i < size; ++i) {
            object.add(FileSystems.getDefault().getPath("foo", new String[0]));
            object.add(FileSystems.getDefault().getPath("foo", "bar"));
        }
        this.testCompress840(object);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 2, 4, 8, 16})
    void testCompress840PriorityQueue(int size) {
        PriorityQueue<Path> object = new PriorityQueue<Path>();
        for (int i = 0; i < size; ++i) {
            object.add(FileSystems.getDefault().getPath("foo", new String[0]));
        }
        this.testCompress840(object);
    }

    @Test
    void testConfiguration() throws ConfigurationException {
        Configurations configManager = new Configurations();
        PropertiesConfiguration config = configManager.properties("src/test/resources/config/test.properties");
        Assertions.assertTrue((boolean)config.containsValue((Object)"jndivalue2"));
        Assertions.assertFalse((boolean)config.containsValue((Object)"notFound"));
        Assertions.assertFalse((boolean)config.containsValue(null));
        Assertions.assertFalse((boolean)config.containsValue((Object)""));
    }

    @Test
    void testCopyAndSave() throws ConfigurationException {
        Configuration copyConf = this.setUpCopyConfig();
        this.conf.copy(copyConf);
        this.checkCopiedConfig(copyConf);
    }

    @Test
    void testDisableIncludes() throws ConfigurationException, IOException {
        String content = PropertiesConfiguration.getInclude() + " = nonExistingIncludeFile" + CR + PROP_NAME + " = " + PROP_VALUE + CR;
        StringReader in = new StringReader(content);
        this.conf = new PropertiesConfiguration();
        this.conf.setIncludesAllowed(false);
        this.conf.read((Reader)in);
        Assertions.assertEquals((Object)PROP_VALUE, (Object)this.conf.getString(PROP_NAME));
    }

    @Test
    void testDisableListDelimiter() throws Exception {
        Assertions.assertEquals((int)4, (int)this.conf.getList("test.mixed.array").size());
        PropertiesConfiguration pc2 = new PropertiesConfiguration();
        TestPropertiesConfiguration.load(pc2, TEST_PROPERTIES);
        Assertions.assertEquals((int)2, (int)pc2.getList("test.mixed.array").size());
    }

    @Test
    void testEmpty() {
        this.checkEmpty("test.empty");
    }

    @Test
    void testEmptyNoSeparator() {
        this.checkEmpty("test.empty2");
    }

    @Test
    void testEscapedKey() throws Exception {
        this.conf.clear();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((Reader)new StringReader("\\u0066\\u006f\\u006f=bar"));
        Assertions.assertEquals((Object)"bar", (Object)this.conf.getString("foo"));
    }

    @Test
    void testEscapedKeyValueSeparator() {
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("test.separator=in.key"));
        Assertions.assertEquals((Object)"bar", (Object)this.conf.getProperty("test.separator:in.key"));
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("test.separator\tin.key"));
        Assertions.assertEquals((Object)"bar", (Object)this.conf.getProperty("test.separator\fin.key"));
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("test.separator in.key"));
    }

    @Test
    void testEscapeQuote() throws ConfigurationException {
        this.conf.clear();
        String text = "\"Hello World!\"";
        this.conf.setProperty(PROP_NAME, (Object)"\"Hello World!\"");
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)out);
        Assertions.assertTrue((boolean)out.toString().contains("\"Hello World!\""));
        this.saveTestConfig();
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        TestPropertiesConfiguration.load(c2, TEST_SAVE_PROPERTIES_FILE.getAbsolutePath());
        Assertions.assertEquals((Object)"\"Hello World!\"", (Object)c2.getString(PROP_NAME));
    }

    @Test
    void testFileWithSharpSymbol() throws Exception {
        File file = TempDirUtils.newFile("sharp#1.properties", this.tempFolder);
        PropertiesConfiguration conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)conf);
        handler.setFile(file);
        handler.load();
        handler.save();
        Assertions.assertTrue((boolean)file.exists());
    }

    @Test
    void testGetFooterSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        Assertions.assertNotNull((Object)this.conf.getFooter());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    void testGetHeaderSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        Assertions.assertNull((Object)this.conf.getHeader());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    void testGetIOFactoryDefault() {
        Assertions.assertNotNull((Object)this.conf.getIOFactory());
    }

    @Test
    void testGetLayout() {
        PropertiesConfigurationLayout layout = this.conf.getLayout();
        Assertions.assertNotNull((Object)layout);
        Assertions.assertSame((Object)layout, (Object)this.conf.getLayout());
        this.conf.setLayout(null);
        PropertiesConfigurationLayout layout2 = this.conf.getLayout();
        Assertions.assertNotNull((Object)layout2);
        Assertions.assertNotSame((Object)layout, (Object)layout2);
    }

    @Test
    void testGetStringWithEscapedChars() {
        String property = this.conf.getString("test.unescape");
        Assertions.assertEquals((Object)"This \n string \t contains \" escaped \\ characters", (Object)property);
    }

    @Test
    void testGetStringWithEscapedComma() {
        String property = this.conf.getString("test.unescape.list-separator");
        Assertions.assertEquals((Object)"This string contains , an escaped list separator", (Object)property);
    }

    @Test
    void testIncludeIncludeLoadAllOnNotFound() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setIncludeListener(PropertiesConfiguration.NOOP_INCLUDE_LISTENER);
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-include-not-found.properties");
        handler.load();
        Assertions.assertEquals((Object)"valueA", (Object)pc.getString("keyA"));
        Assertions.assertEquals((Object)"valueB", (Object)pc.getString("keyB"));
    }

    @Test
    void testIncludeIncludeLoadCyclicalReferenceFail() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-include-cyclical-reference.properties");
        Assertions.assertThrows(ConfigurationException.class, () -> ((FileHandler)handler).load());
        Assertions.assertNull((Object)pc.getString("keyA"));
    }

    @Test
    void testIncludeIncludeLoadCyclicalReferenceIgnore() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setIncludeListener(PropertiesConfiguration.NOOP_INCLUDE_LISTENER);
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-include-cyclical-reference.properties");
        handler.load();
        Assertions.assertEquals((Object)"valueA", (Object)pc.getString("keyA"));
    }

    @Test
    void testIncludeInSubDir() throws ConfigurationException {
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFileName("testFactoryPropertiesInclude.xml")});
        Configuration config = (Configuration)builder.getConfiguration();
        Assertions.assertTrue((boolean)config.getBoolean("deeptest"));
        Assertions.assertTrue((boolean)config.getBoolean("deepinclude"));
        Assertions.assertFalse((boolean)config.containsKey("deeptestinvalid"));
    }

    @Test
    void testIncludeLoadAllOnLoadException() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setIncludeListener(PropertiesConfiguration.NOOP_INCLUDE_LISTENER);
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-load-exception.properties");
        handler.load();
        Assertions.assertEquals((Object)"valueA", (Object)pc.getString("keyA"));
    }

    @Test
    void testIncludeLoadAllOnNotFound() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setIncludeListener(PropertiesConfiguration.NOOP_INCLUDE_LISTENER);
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-not-found.properties");
        handler.load();
        Assertions.assertEquals((Object)"valueA", (Object)pc.getString("keyA"));
    }

    @Test
    void testIncludeLoadCyclicalMultiStepReferenceFail() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-cyclical-root.properties");
        Assertions.assertThrows(ConfigurationException.class, () -> ((FileHandler)handler).load());
        Assertions.assertNull((Object)pc.getString("keyA"));
    }

    @Test
    void testIncludeLoadCyclicalMultiStepReferenceIgnore() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setIncludeListener(PropertiesConfiguration.NOOP_INCLUDE_LISTENER);
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-cyclical-root.properties");
        handler.load();
        Assertions.assertEquals((Object)"valueA", (Object)pc.getString("keyA"));
    }

    @Test
    void testIncludeLoadCyclicalReferenceFail() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-cyclical-reference.properties");
        Assertions.assertThrows(ConfigurationException.class, () -> ((FileHandler)handler).load());
        Assertions.assertNull((Object)pc.getString("keyA"));
    }

    @Test
    void testIncludeLoadCyclicalReferenceIgnore() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setIncludeListener(PropertiesConfiguration.NOOP_INCLUDE_LISTENER);
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("include-cyclical-reference.properties");
        handler.load();
        Assertions.assertEquals((Object)"valueA", (Object)pc.getString("keyA"));
    }

    @Test
    void testInitFromNonExistingFile() throws ConfigurationException {
        String testProperty = "test.successfull";
        this.conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setFile(TEST_SAVE_PROPERTIES_FILE);
        this.conf.addProperty("test.successfull", (Object)"true");
        handler.save();
        this.checkSavedConfig();
    }

    @Test
    void testInMemoryCreatedSave() throws Exception {
        this.conf = new PropertiesConfiguration();
        this.conf.addProperty("string", (Object)"value1");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < 5; ++i) {
            list.add(PROP_VALUE + i);
        }
        this.conf.addProperty("array", list);
        this.saveTestConfig();
        Assertions.assertTrue((boolean)TEST_SAVE_PROPERTIES_FILE.exists());
        this.checkSavedConfig();
    }

    @Test
    void testIsCommentLine() {
        Assertions.assertTrue((boolean)PropertiesConfiguration.isCommentLine((String)"# a comment"));
        Assertions.assertTrue((boolean)PropertiesConfiguration.isCommentLine((String)"! a comment"));
        Assertions.assertTrue((boolean)PropertiesConfiguration.isCommentLine((String)"#a comment"));
        Assertions.assertTrue((boolean)PropertiesConfiguration.isCommentLine((String)"    ! a comment"));
        Assertions.assertFalse((boolean)PropertiesConfiguration.isCommentLine((String)"   a#comment"));
    }

    @Test
    void testJupRead() throws IOException, ConfigurationException {
        this.conf.clear();
        this.conf.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory());
        String testFilePath = ConfigurationAssert.getTestFile("jup-test.properties").getAbsolutePath();
        TestPropertiesConfiguration.load(this.conf, testFilePath);
        Properties jup = new Properties();
        try (InputStream in = Files.newInputStream(Paths.get(testFilePath, new String[0]), new OpenOption[0]);){
            jup.load(in);
        }
        HashSet pcKeys = new HashSet(IteratorUtils.toList((Iterator)this.conf.getKeys()));
        Assertions.assertEquals(jup.keySet(), pcKeys);
        for (Object key : jup.keySet()) {
            String keyString = key.toString();
            Assertions.assertEquals((Object)jup.getProperty(keyString), (Object)this.conf.getProperty(keyString), (String)("Wrong property value for '" + keyString + "'"));
        }
    }

    @Test
    void testJupWrite() throws IOException, ConfigurationException {
        this.conf.clear();
        this.conf.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory());
        String testFilePath = ConfigurationAssert.getTestFile("jup-test.properties").getAbsolutePath();
        Properties origProps = new Properties();
        try (InputStream in = Files.newInputStream(Paths.get(testFilePath, new String[0]), new OpenOption[0]);){
            origProps.load(in);
        }
        for (Object e : origProps.keySet()) {
            String keyString = e.toString();
            this.conf.setProperty(keyString, (Object)origProps.getProperty(keyString));
        }
        this.saveTestConfig();
        Assertions.assertTrue((boolean)TEST_SAVE_PROPERTIES_FILE.exists());
        Properties testProps = new Properties();
        try (InputStream inputStream = Files.newInputStream(TEST_SAVE_PROPERTIES_FILE.toPath(), new OpenOption[0]);){
            testProps.load(inputStream);
        }
        HashSet hashSet = new HashSet(IteratorUtils.toList((Iterator)this.conf.getKeys()));
        Assertions.assertEquals(testProps.keySet(), hashSet);
        for (Object key : testProps.keySet()) {
            String keyString = key.toString();
            Assertions.assertEquals((Object)testProps.getProperty(keyString), (Object)this.conf.getProperty(keyString), (String)("Wrong property value for '" + keyString + "'"));
        }
    }

    @Test
    void testJupWriteUtf8WithoutUnicodeEscapes() throws IOException, ConfigurationException {
        this.conf.clear();
        this.conf.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory(false));
        String testFilePath = ConfigurationAssert.getTestFile("jup-test.properties").getAbsolutePath();
        Properties origProps = new Properties();
        try (InputStream in = Files.newInputStream(Paths.get(testFilePath, new String[0]), new OpenOption[0]);){
            origProps.load(in);
        }
        for (Object e : origProps.keySet()) {
            String keyString = e.toString();
            this.conf.setProperty(keyString, (Object)origProps.getProperty(keyString));
        }
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setEncoding(StandardCharsets.UTF_8.name());
        handler.save(TEST_SAVE_PROPERTIES_FILE);
        Assertions.assertTrue((boolean)TEST_SAVE_PROPERTIES_FILE.exists());
        Properties properties = new Properties();
        try (BufferedReader in = Files.newBufferedReader(TEST_SAVE_PROPERTIES_FILE.toPath(), StandardCharsets.UTF_8);){
            properties.load(in);
        }
        HashSet pcKeys = new HashSet(IteratorUtils.toList((Iterator)this.conf.getKeys()));
        Assertions.assertEquals(properties.keySet(), pcKeys);
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            Assertions.assertEquals((Object)properties.getProperty(keyString), (Object)this.conf.getProperty(keyString), (String)("Wrong property value for '" + keyString + "'"));
        }
        for (String line : Files.readAllLines(TEST_SAVE_PROPERTIES_FILE.toPath())) {
            Assertions.assertFalse((boolean)line.contains("\\u"));
        }
    }

    @Test
    void testKeepSeparators() throws ConfigurationException, IOException {
        this.saveTestConfig();
        HashSet<String> separatorTests = new HashSet<String>(Arrays.asList("test.separator.equal = foo", "test.separator.colon : foo", "test.separator.tab\tfoo", "test.separator.whitespace foo", "test.separator.no.space=foo"));
        HashSet<String> foundLines = new HashSet<String>();
        try (BufferedReader in = new BufferedReader(new FileReader(TEST_SAVE_PROPERTIES_FILE));){
            String s;
            while ((s = in.readLine()) != null) {
                for (String separatorTest : separatorTests) {
                    if (!separatorTest.equals(s)) continue;
                    foundLines.add(s);
                }
            }
        }
        Assertions.assertEquals(separatorTests, foundLines);
    }

    @Test
    void testKeyValueSeparators() {
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("test.separator.equal"));
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("test.separator.colon"));
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("test.separator.tab"));
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("test.separator.formfeed"));
        Assertions.assertEquals((Object)"foo", (Object)this.conf.getProperty("test.separator.whitespace"));
    }

    @Test
    void testLargeKey() throws Exception {
        this.conf.clear();
        String key = String.join((CharSequence)"", Collections.nCopies(10000, "x"));
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((Reader)new StringReader(key));
        Assertions.assertEquals((Object)"", (Object)this.conf.getString(key));
    }

    @Test
    void testLineSeparator() throws ConfigurationException {
        String eol = System.lineSeparator();
        this.conf = new PropertiesConfiguration();
        this.conf.setHeader("My header");
        this.conf.setProperty("prop", (Object)PROP_VALUE);
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)out);
        String content = out.toString();
        Assertions.assertEquals((int)0, (int)content.indexOf("# My header" + eol + eol));
        Assertions.assertTrue((boolean)content.contains("prop = value" + eol));
    }

    @Test
    void testList() throws Exception {
        List packages = this.conf.getList("packages");
        Assertions.assertEquals((int)3, (int)packages.size());
    }

    @Test
    void testLoad() throws Exception {
        String loaded = this.conf.getString("configuration.loaded");
        Assertions.assertEquals((Object)"true", (Object)loaded);
    }

    @Test
    void testLoadFromFile() throws Exception {
        File file = ConfigurationAssert.getTestFile("test.properties");
        this.conf.clear();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setFile(file);
        handler.load();
        Assertions.assertEquals((Object)"true", (Object)this.conf.getString("configuration.loaded"));
    }

    @Test
    void testLoadInclude() throws Exception {
        String loaded = this.conf.getString("include.loaded");
        Assertions.assertEquals((Object)"true", (Object)loaded);
    }

    @Test
    void testLoadIncludeFileViaFileSystem() throws ConfigurationException {
        this.conf.clear();
        this.conf.addProperty("include", (Object)"include.properties");
        this.saveTestConfig();
        DefaultFileSystem fs = new DefaultFileSystem(){

            public InputStream getInputStream(URL url) throws ConfigurationException {
                if (url.toString().endsWith("include.properties")) {
                    return new ByteArrayInputStream("test.outcome = success".getBytes(StandardCharsets.UTF_8));
                }
                return super.getInputStream(url);
            }
        };
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        builder.configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)params.fileBased().setFile(TEST_SAVE_PROPERTIES_FILE)).setBasePath(ConfigurationAssert.OUT_DIR.toURI().toString())).setFileSystem((FileSystem)fs)});
        PropertiesConfiguration configuration = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertEquals((Object)"success", (Object)configuration.getString("test.outcome"));
    }

    @Test
    void testLoadIncludeFromClassPath() {
        Assertions.assertEquals((Object)"true", (Object)this.conf.getString("include.loaded"));
    }

    @Test
    void testLoadIncludeFromReader() throws ConfigurationException {
        StringReader in = new StringReader(PropertiesConfiguration.getInclude() + " = " + ConfigurationAssert.getTestURL("include.properties"));
        this.conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load((Reader)in);
        Assertions.assertEquals((Object)"true", (Object)this.conf.getString("include.loaded"));
    }

    @Test
    void testLoadIncludeInterpol() throws Exception {
        String loaded = this.conf.getString("include.interpol.loaded");
        Assertions.assertEquals((Object)"true", (Object)loaded);
    }

    @Test
    void testLoadIncludeOptional() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("includeoptional.properties");
        handler.load();
        Assertions.assertTrue((boolean)pc.getBoolean("includeoptional.loaded"));
    }

    @Test
    void testLoadUnexistingFile() {
        Assertions.assertThrows(ConfigurationException.class, () -> TestPropertiesConfiguration.load(this.conf, "unexisting file"));
    }

    @Test
    void testLoadViaPropertyWithBasePath() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH);
        handler.setFileName("test.properties");
        handler.load();
        Assertions.assertTrue((boolean)pc.getBoolean("test.boolean"));
    }

    @Test
    void testLoadViaPropertyWithBasePath2() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)pc);
        handler.setBasePath(TEST_BASE_PATH_2);
        handler.setFileName("test.properties");
        handler.load();
        Assertions.assertTrue((boolean)pc.getBoolean("test.boolean"));
    }

    @Test
    void testMixedArray() {
        Object[] array = this.conf.getStringArray("test.mixed.array");
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])array);
    }

    @Test
    void testMultilines() {
        String property = "This is a value spread out across several adjacent natural lines by escaping the line terminator with a backslash character.";
        Assertions.assertEquals((Object)"This is a value spread out across several adjacent natural lines by escaping the line terminator with a backslash character.", (Object)this.conf.getString("test.multilines"));
    }

    @Test
    void testMultipleIncludeFiles() throws ConfigurationException {
        this.conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.load(ConfigurationAssert.getTestFile("config/testMultiInclude.properties"));
        Assertions.assertEquals((Object)"topValue", (Object)this.conf.getString("top"));
        Assertions.assertEquals((int)100, (int)this.conf.getInt("property.c"));
        Assertions.assertTrue((boolean)this.conf.getBoolean("include.loaded"));
    }

    @Test
    void testNewLineEscaping() {
        List list = this.conf.getList("test.path");
        Assertions.assertEquals(Arrays.asList("C:\\path1\\", "C:\\path2\\", "C:\\path3\\complex\\test\\"), (Object)list);
    }

    @Test
    void testPropertyLoaded() throws ConfigurationException {
        DummyLayout layout = new DummyLayout();
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.propertyLoaded("layoutLoadedProperty", "yes", null);
        Assertions.assertEquals((int)0, (int)layout.loadCalls);
        Assertions.assertEquals((Object)"yes", (Object)this.conf.getString("layoutLoadedProperty"));
    }

    @Test
    void testPropertyLoadedInclude() throws ConfigurationException {
        DummyLayout layout = new DummyLayout();
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.propertyLoaded(PropertiesConfiguration.getInclude(), "testClasspath.properties,testEqual.properties", new ArrayDeque());
        Assertions.assertEquals((int)2, (int)layout.loadCalls);
        Assertions.assertFalse((boolean)this.conf.containsKey(PropertiesConfiguration.getInclude()));
    }

    @Test
    void testPropertyLoadedIncludeNotAllowed() throws ConfigurationException {
        DummyLayout layout = new DummyLayout();
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.setIncludesAllowed(false);
        this.conf.propertyLoaded(PropertiesConfiguration.getInclude(), "testClassPath.properties,testEqual.properties", null);
        Assertions.assertEquals((int)0, (int)layout.loadCalls);
        Assertions.assertFalse((boolean)this.conf.containsKey(PropertiesConfiguration.getInclude()));
    }

    @Test
    void testReadCalledDirectly() throws IOException {
        this.conf = new PropertiesConfiguration();
        try (FileReader in = new FileReader(ConfigurationAssert.getTestFile("test.properties"));){
            ConfigurationException e = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> this.conf.read(in));
            Assertions.assertTrue((boolean)e.getMessage().contains("FileHandler"));
        }
    }

    @Test
    void testReadFooterComment() {
        Assertions.assertEquals((Object)"\n# This is a foot comment\n", (Object)this.conf.getFooter());
        Assertions.assertEquals((Object)"\nThis is a foot comment\n", (Object)this.conf.getLayout().getCanonicalFooterCooment(false));
    }

    @Test
    void testReference() throws Exception {
        Assertions.assertEquals((Object)"baseextra", (Object)this.conf.getString("base.reference"));
    }

    @Test
    void testSave() throws Exception {
        this.conf.addProperty("string", (Object)"value1");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < 5; ++i) {
            list.add(PROP_VALUE + i);
        }
        this.conf.addProperty("array", list);
        this.saveTestConfig();
        Assertions.assertTrue((boolean)TEST_SAVE_PROPERTIES_FILE.exists());
        this.checkSavedConfig();
    }

    @Test
    void testSaveEscapedEscapingCharacter() throws ConfigurationException {
        this.conf.addProperty("test.dirs", (Object)"C:\\Temp\\\\,D:\\Data\\\\,E:\\Test\\");
        List dirs = this.conf.getList("test.dirs");
        Assertions.assertEquals((int)3, (int)dirs.size());
        this.saveTestConfig();
        this.checkSavedConfig();
    }

    @Test
    void testSaveMissingFileName() {
        FileHandler handler = new FileHandler((FileBased)this.conf);
        Assertions.assertThrows(ConfigurationException.class, () -> ((FileHandler)handler).save());
    }

    @Test
    void testSaveToCustomURL() throws Exception {
        URL url = new URL("foo", "", 0, TempDirUtils.newFile("testsave-custom-url.properties", this.tempFolder).getAbsolutePath(), new FileURLStreamHandler());
        FileHandler handlerSave = new FileHandler((FileBased)this.conf);
        handlerSave.save(url);
        PropertiesConfiguration config2 = new PropertiesConfiguration();
        FileHandler handlerLoad = new FileHandler((FileBased)config2);
        handlerLoad.load(url);
        Assertions.assertEquals((Object)"true", (Object)config2.getString("configuration.loaded"));
    }

    @Test
    void testSaveToHTTPServerFail() throws Exception {
        MockHttpURLStreamHandler handler = new MockHttpURLStreamHandler(400, TEST_SAVE_PROPERTIES_FILE);
        URL url = new URL(null, "http://jakarta.apache.org", handler);
        FileHandler fileHandler = new FileHandler((FileBased)this.conf);
        ConfigurationException cex = (ConfigurationException)Assertions.assertThrows(ConfigurationException.class, () -> fileHandler.save(url));
        Assertions.assertInstanceOf(IOException.class, (Object)cex.getCause());
    }

    @Test
    void testSaveToHTTPServerSuccess() throws Exception {
        MockHttpURLStreamHandler handler = new MockHttpURLStreamHandler(200, TEST_SAVE_PROPERTIES_FILE);
        URL url = new URL(null, "http://jakarta.apache.org", handler);
        new FileHandler((FileBased)this.conf).save(url);
        MockHttpURLConnection con = handler.getMockConnection();
        Assertions.assertTrue((boolean)con.getDoOutput());
        Assertions.assertEquals((Object)"PUT", (Object)con.getRequestMethod());
        this.checkSavedConfig();
    }

    @Test
    void testSaveWithBasePath() throws Exception {
        this.conf.setProperty("test", (Object)"true");
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setBasePath(TEST_SAVE_PROPERTIES_FILE.getParentFile().toURI().toURL().toString());
        handler.setFileName(TEST_SAVE_PROPERTIES_FILE.getName());
        handler.save();
        Assertions.assertTrue((boolean)TEST_SAVE_PROPERTIES_FILE.exists());
    }

    @Test
    void testSaveWithDataConfig() throws ConfigurationException {
        this.conf = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)this.conf);
        handler.setFile(TEST_SAVE_PROPERTIES_FILE);
        DataConfiguration dataConfig = new DataConfiguration((Configuration)this.conf);
        dataConfig.setProperty("foo", (Object)"bar");
        Assertions.assertEquals((Object)"bar", (Object)this.conf.getString("foo"));
        handler.save();
        PropertiesConfiguration config2 = new PropertiesConfiguration();
        TestPropertiesConfiguration.load(config2, TEST_SAVE_PROPERTIES_FILE.getAbsolutePath());
        Assertions.assertEquals((Object)"bar", (Object)config2.getString("foo"));
    }

    @Test
    void testSaveWithDefaultListDelimiterHandler() throws ConfigurationException {
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.saveTestConfig();
        PropertiesConfiguration checkConfig = new PropertiesConfiguration();
        checkConfig.setListDelimiterHandler(this.conf.getListDelimiterHandler());
        new FileHandler((FileBased)checkConfig).load(TEST_SAVE_PROPERTIES_FILE);
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)checkConfig);
    }

    @Test
    void testSaveWithDelimiterParsingDisabled() throws ConfigurationException {
        this.conf.clear();
        this.conf.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        this.conf.addProperty("test.list", (Object)"a,b,c");
        this.conf.addProperty("test.dirs", (Object)"C:\\Temp\\,D:\\Data\\");
        this.saveTestConfig();
        PropertiesConfiguration checkConfig = new PropertiesConfiguration();
        checkConfig.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        new FileHandler((FileBased)checkConfig).load(TEST_SAVE_PROPERTIES_FILE);
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.conf, (ImmutableConfiguration)checkConfig);
    }

    @Test
    void testSetFooterSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.setFooter("new comment");
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    void testSetHeaderSynchronized() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.conf.setSynchronizer((Synchronizer)sync);
        this.conf.setHeader("new comment");
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    void testSetInclude() throws Exception {
        this.conf.clear();
        PropertiesConfiguration.setInclude((String)"import");
        TestPropertiesConfiguration.load(this.conf, TEST_PROPERTIES);
        PropertiesConfiguration.setInclude((String)"include");
        Assertions.assertNull((Object)this.conf.getString("include.loaded"));
    }

    @Test
    void testSetIOFactoryNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.conf.setIOFactory(null));
    }

    @Test
    void testSetIOFactoryReader() throws ConfigurationException {
        int propertyCount = 10;
        this.conf.clear();
        this.conf.setIOFactory(new PropertiesConfiguration.IOFactory(){

            public PropertiesConfiguration.PropertiesReader createPropertiesReader(Reader in) {
                return new PropertiesReaderTestImpl(in, 10);
            }

            public PropertiesConfiguration.PropertiesWriter createPropertiesWriter(Writer out, ListDelimiterHandler handler) {
                throw new UnsupportedOperationException("Unexpected call!");
            }
        });
        TestPropertiesConfiguration.load(this.conf, TEST_PROPERTIES);
        for (int i = 1; i <= 10; ++i) {
            Assertions.assertEquals((Object)(PROP_VALUE + i), (Object)this.conf.getString(PROP_NAME + i), (String)("Wrong property value at " + i));
        }
    }

    @Test
    void testSetIOFactoryWriter() throws ConfigurationException, IOException {
        final MutableObject propertiesWriter = new MutableObject();
        this.conf.setIOFactory(new PropertiesConfiguration.IOFactory(){

            public PropertiesConfiguration.PropertiesReader createPropertiesReader(Reader in) {
                throw new UnsupportedOperationException("Unexpected call!");
            }

            public PropertiesConfiguration.PropertiesWriter createPropertiesWriter(Writer out, ListDelimiterHandler handler) {
                try {
                    PropertiesWriterTestImpl propWriter = new PropertiesWriterTestImpl(handler);
                    propertiesWriter.setValue((Object)propWriter);
                    return propWriter;
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        new FileHandler((FileBased)this.conf).save((Writer)new StringWriter());
        ((Writer)propertiesWriter.getValue()).close();
        this.checkSavedConfig();
    }

    @Test
    void testSetPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        String prop = "delimiterListProp";
        this.conf.setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.setProperty("delimiterListProp", list);
        this.saveTestConfig();
        this.conf.clear();
        TestPropertiesConfiguration.load(this.conf, TEST_SAVE_PROPERTIES_FILE.getAbsolutePath());
        Assertions.assertEquals(list, (Object)this.conf.getProperty("delimiterListProp"));
    }

    @Test
    void testSlashEscaping() throws ConfigurationException {
        this.conf.setProperty(PROP_NAME, (Object)"http://www.apache.org");
        StringWriter writer = new StringWriter();
        new FileHandler((FileBased)this.conf).save((Writer)writer);
        String s = writer.toString();
        Assertions.assertTrue((boolean)s.contains("testProperty = http://www.apache.org"));
    }

    @Test
    void testUnEscapeCharacters() {
        Assertions.assertEquals((Object)"#1 =: me!", (Object)this.conf.getString("test.unescape.characters"));
    }

    @Test
    void testUnescapeJava() {
        Assertions.assertEquals((Object)"test\\,test", (Object)PropertiesConfiguration.unescapeJava((String)"test\\,test"));
    }

    @Test
    void testWriteFooterComment() throws ConfigurationException, IOException {
        String footer = "my footer";
        this.conf.clear();
        this.conf.setProperty(PROP_NAME, (Object)PROP_VALUE);
        this.conf.setFooter("my footer");
        StringWriter out = new StringWriter();
        this.conf.write((Writer)out);
        Assertions.assertEquals((Object)("testProperty = value" + CR + "# " + "my footer" + CR), (Object)out.toString());
    }

    static class DummyLayout
    extends PropertiesConfigurationLayout {
        private int loadCalls;

        DummyLayout() {
        }

        public void load(PropertiesConfiguration config, Reader in) throws ConfigurationException {
            ++this.loadCalls;
        }
    }

    static class MockHttpURLStreamHandler
    extends URLStreamHandler {
        private final int responseCode;
        private final File outputFile;
        private MockHttpURLConnection connection;

        public MockHttpURLStreamHandler(int respCode, File outFile) {
            this.responseCode = respCode;
            this.outputFile = outFile;
        }

        public MockHttpURLConnection getMockConnection() {
            return this.connection;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            this.connection = new MockHttpURLConnection(u, this.responseCode, this.outputFile);
            return this.connection;
        }
    }

    static class MockHttpURLConnection
    extends HttpURLConnection {
        private final int returnCode;
        private final File outputFile;

        protected MockHttpURLConnection(URL u, int respCode, File outFile) {
            super(u);
            this.returnCode = respCode;
            this.outputFile = outFile;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public void disconnect() {
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new FileOutputStream(this.outputFile);
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.returnCode;
        }

        @Override
        public boolean usingProxy() {
            return false;
        }
    }

    private static final class PropertiesWriterTestImpl
    extends PropertiesConfiguration.PropertiesWriter {
        public PropertiesWriterTestImpl(ListDelimiterHandler handler) throws IOException {
            super((Writer)new FileWriter(TEST_SAVE_PROPERTIES_FILE), handler);
        }
    }

    private static final class PropertiesReaderTestImpl
    extends PropertiesConfiguration.PropertiesReader {
        private final int maxProperties;
        private int propertyCount;

        public PropertiesReaderTestImpl(Reader reader, int maxProps) {
            super(reader);
            this.maxProperties = maxProps;
        }

        public String getPropertyName() {
            return TestPropertiesConfiguration.PROP_NAME + this.propertyCount;
        }

        public String getPropertyValue() {
            return TestPropertiesConfiguration.PROP_VALUE + this.propertyCount;
        }

        public boolean nextProperty() throws IOException {
            ++this.propertyCount;
            return this.propertyCount <= this.maxProperties;
        }
    }
}

