/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ex.ConversionException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDefaultImmutableConfiguration {
    private final MapImmutableConfiguration config = new MapImmutableConfiguration();

    @BeforeEach
    @AfterEach
    public void clearMap() {
        this.config.map.clear();
    }

    @Test
    void testContainsValueDefaultImplementation() {
        this.config.map.put("test", "213123");
        Assertions.assertFalse((boolean)this.config.containsValue(""));
        Assertions.assertFalse((boolean)this.config.containsValue(null));
        Assertions.assertTrue((boolean)this.config.containsValue("213123"));
    }

    @Test
    void testGetDuration() {
        Duration d = Duration.ofSeconds(1L);
        this.config.map.put("durationD", d.toString());
        Duration oneD = Duration.ofSeconds(1L);
        Duration twoD = Duration.ofSeconds(2L);
        Assertions.assertEquals((Object)oneD, (Object)this.config.getDuration("durationD"));
        Assertions.assertEquals((Object)oneD, (Object)this.config.getDuration("durationD", twoD));
        Assertions.assertEquals((Object)twoD, (Object)this.config.getDuration("numberNotInConfig", twoD));
        Assertions.assertEquals((Object)oneD, (Object)this.config.getDuration("durationD", twoD));
    }

    @Test
    void testGetDurationIncompatibleType() {
        this.config.map.put("test.empty", "");
        Assertions.assertThrows(ConversionException.class, () -> this.config.getDuration("test.empty"));
    }

    @Test
    void testGetDurationUnknown() {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.config.getDuration("numberNotInConfig"));
    }

    private static final class MapImmutableConfiguration
    implements ImmutableConfiguration {
        private final Map<String, Object> map = new HashMap<String, Object>();

        private MapImmutableConfiguration() {
        }

        public boolean containsKey(String key) {
            return false;
        }

        public <T> T get(Class<T> cls, String key) {
            return null;
        }

        public <T> T get(Class<T> cls, String key, T defaultValue) {
            return null;
        }

        public Object getArray(Class<?> cls, String key) {
            return null;
        }

        public Object getArray(Class<?> cls, String key, Object defaultValue) {
            return null;
        }

        public BigDecimal getBigDecimal(String key) {
            return null;
        }

        public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
            return null;
        }

        public BigInteger getBigInteger(String key) {
            return null;
        }

        public BigInteger getBigInteger(String key, BigInteger defaultValue) {
            return null;
        }

        public boolean getBoolean(String key) {
            return false;
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            return false;
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            return null;
        }

        public byte getByte(String key) {
            return 0;
        }

        public byte getByte(String key, byte defaultValue) {
            return 0;
        }

        public Byte getByte(String key, Byte defaultValue) {
            return null;
        }

        public <T> Collection<T> getCollection(Class<T> cls, String key, Collection<T> target) {
            return null;
        }

        public <T> Collection<T> getCollection(Class<T> cls, String key, Collection<T> target, Collection<T> defaultValue) {
            return null;
        }

        public double getDouble(String key) {
            return 0.0;
        }

        public double getDouble(String key, double defaultValue) {
            return 0.0;
        }

        public Double getDouble(String key, Double defaultValue) {
            return null;
        }

        public String getEncodedString(String key) {
            return null;
        }

        public String getEncodedString(String key, ConfigurationDecoder decoder) {
            return null;
        }

        public float getFloat(String key) {
            return 0.0f;
        }

        public float getFloat(String key, float defaultValue) {
            return 0.0f;
        }

        public Float getFloat(String key, Float defaultValue) {
            return null;
        }

        public int getInt(String key) {
            return 0;
        }

        public int getInt(String key, int defaultValue) {
            return 0;
        }

        public Integer getInteger(String key, Integer defaultValue) {
            return null;
        }

        public Iterator<String> getKeys() {
            return this.map.keySet().iterator();
        }

        public Iterator<String> getKeys(String prefix) {
            return null;
        }

        public <T> List<T> getList(Class<T> cls, String key) {
            return null;
        }

        public <T> List<T> getList(Class<T> cls, String key, List<T> defaultValue) {
            return null;
        }

        public List<Object> getList(String key) {
            return null;
        }

        public List<Object> getList(String key, List<?> defaultValue) {
            return null;
        }

        public long getLong(String key) {
            return 0L;
        }

        public long getLong(String key, long defaultValue) {
            return 0L;
        }

        public Long getLong(String key, Long defaultValue) {
            return null;
        }

        public Properties getProperties(String key) {
            return null;
        }

        public Object getProperty(String key) {
            return this.map.get(key);
        }

        public short getShort(String key) {
            return 0;
        }

        public short getShort(String key, short defaultValue) {
            return 0;
        }

        public Short getShort(String key, Short defaultValue) {
            return null;
        }

        public String getString(String key) {
            return Objects.toString(this.map.get(key), null);
        }

        public String getString(String key, String defaultValue) {
            return null;
        }

        public String[] getStringArray(String key) {
            return null;
        }

        public ImmutableConfiguration immutableSubset(String prefix) {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }

        public int size() {
            return 0;
        }
    }
}

