/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.junit.jupiter.api.Assertions;

public class NonStringTestHolder {
    private Configuration configuration;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    void testBoolean() throws Exception {
        boolean booleanValue = this.configuration.getBoolean("test.boolean");
        Assertions.assertTrue((boolean)booleanValue);
        Assertions.assertEquals((int)1, (int)this.configuration.getList("test.boolean").size());
    }

    void testBooleanDefaultValue() throws Exception {
        boolean booleanValue = this.configuration.getBoolean("test.boolean.missing", true);
        Assertions.assertTrue((boolean)booleanValue);
        Boolean booleanObject = this.configuration.getBoolean("test.boolean.missing", Boolean.valueOf(true));
        Assertions.assertEquals((Object)true, (Object)booleanObject);
    }

    void testByte() throws Exception {
        int testValue = 10;
        byte byteValue = this.configuration.getByte("test.byte");
        Assertions.assertEquals((byte)10, (byte)byteValue);
        Assertions.assertEquals((int)1, (int)this.configuration.getList("test.byte").size());
    }

    void testDouble() throws Exception {
        double testValue = 10.25;
        double doubleValue = this.configuration.getDouble("test.double");
        Assertions.assertEquals((double)10.25, (double)doubleValue, (double)0.01);
        Assertions.assertEquals((int)1, (int)this.configuration.getList("test.double").size());
    }

    void testDoubleDefaultValue() throws Exception {
        double testValue = 10.25;
        double doubleValue = this.configuration.getDouble("test.double.missing", 10.25);
        Assertions.assertEquals((double)10.25, (double)doubleValue, (double)0.01);
    }

    void testFloat() throws Exception {
        float testValue = 20.25f;
        float floatValue = this.configuration.getFloat("test.float");
        Assertions.assertEquals((double)20.25, (double)floatValue, (double)0.01);
        Assertions.assertEquals((int)1, (int)this.configuration.getList("test.float").size());
    }

    void testFloatDefaultValue() throws Exception {
        float testValue = 20.25f;
        float floatValue = this.configuration.getFloat("test.float.missing", 20.25f);
        Assertions.assertEquals((double)20.25, (double)floatValue, (double)0.01);
    }

    void testInteger() throws Exception {
        int intValue = this.configuration.getInt("test.integer");
        Assertions.assertEquals((int)10, (int)intValue);
        Assertions.assertEquals((int)1, (int)this.configuration.getList("test.integer").size());
    }

    void testIntegerDefaultValue() throws Exception {
        int intValue = this.configuration.getInt("test.integer.missing", 10);
        Assertions.assertEquals((int)10, (int)intValue);
    }

    void testIsEmpty() throws Exception {
        Assertions.assertFalse((boolean)this.configuration.isEmpty());
    }

    void testListMissing() throws Exception {
        List list = this.configuration.getList("missing.list");
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    void testLong() throws Exception {
        long longValue = this.configuration.getLong("test.long");
        Assertions.assertEquals((long)1000000L, (long)longValue);
        Assertions.assertEquals((int)1, (int)this.configuration.getList("test.long").size());
    }

    void testLongDefaultValue() throws Exception {
        long longValue = this.configuration.getLong("test.long.missing", 1000000L);
        Assertions.assertEquals((long)1000000L, (long)longValue);
    }

    void testShort() throws Exception {
        short shortValue = this.configuration.getShort("test.short");
        Assertions.assertEquals((int)1, (int)shortValue);
        Assertions.assertEquals((int)1, (int)this.configuration.getList("test.short").size());
    }

    void testShortDefaultValue() throws Exception {
        short shortValue = this.configuration.getShort("test.short.missing", (short)1);
        Assertions.assertEquals((int)1, (int)shortValue);
    }

    void testSubset() throws Exception {
        Configuration subset = this.configuration.subset("test");
        boolean foundKeyValue = false;
        Iterator it = subset.getKeys();
        while (it.hasNext() && !foundKeyValue) {
            String key = (String)it.next();
            foundKeyValue = "short".equals(key);
        }
        Assertions.assertTrue((boolean)foundKeyValue);
    }
}

