/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.util.List;
import java.util.Map;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.FileMeta;
import org.apache.celeborn.common.util.ShuffleBlockInfoUtils;
import org.apache.celeborn.shaded.io.netty.buffer.CompositeByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryFileInfo
extends FileInfo {
    Logger logger = LoggerFactory.getLogger(MemoryFileInfo.class);
    private CompositeByteBuf buffer;
    private CompositeByteBuf sortedBuffer;
    private Map<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> sortedIndexes;

    public MemoryFileInfo(UserIdentifier userIdentifier, boolean partitionSplitEnabled, FileMeta fileMeta) {
        super(userIdentifier, partitionSplitEnabled, fileMeta);
    }

    public MemoryFileInfo(UserIdentifier userIdentifier, boolean partitionSplitEnabled, FileMeta fileMeta, CompositeByteBuf buffer) {
        super(userIdentifier, partitionSplitEnabled, fileMeta);
        this.buffer = buffer;
    }

    public CompositeByteBuf getBuffer() {
        return this.buffer;
    }

    public void setBuffer(CompositeByteBuf buffer) {
        this.buffer = buffer;
    }

    public CompositeByteBuf getSortedBuffer() {
        return this.sortedBuffer;
    }

    public void setSortedBuffer(CompositeByteBuf sortedBuffer) {
        this.sortedBuffer = sortedBuffer;
    }

    public Map<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> getSortedIndexes() {
        return this.sortedIndexes;
    }

    public void setSortedIndexes(Map<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> sortedIndexes) {
        this.sortedIndexes = sortedIndexes;
    }

    public int releaseMemoryBuffers() {
        int bufferSize = 0;
        if (this.buffer != null) {
            bufferSize = this.buffer.writerIndex();
            this.buffer.release();
        }
        this.logger.info("Memory File Info {} expire, removed {}", (Object)this, (Object)bufferSize);
        return bufferSize;
    }

    @Override
    public String getFilePath() {
        return "";
    }
}

