/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.util.Collections;
import java.util.Map;
import org.apache.celeborn.reflect.DynConstructors;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.memory.SparkOutOfMemoryError;

public class SparkCommonUtils {
    public static void validateAttemptConfig(SparkConf conf) throws IllegalArgumentException {
        int DEFAULT_MAX_CONSECUTIVE_STAGE_ATTEMPTS = 4;
        int maxStageAttempts = conf.getInt("spark.stage.maxConsecutiveAttempts", DEFAULT_MAX_CONSECUTIVE_STAGE_ATTEMPTS);
        int maxTaskAttempts = conf.getInt("spark.task.maxFailures", 4);
        if (maxStageAttempts >= 32768 || maxTaskAttempts >= 65536) {
            throw new IllegalArgumentException("The spark.stage.maxConsecutiveAttempts should be less than 32768 (currently " + maxStageAttempts + ")and spark.task.maxFailures should be less than 65536 (currently " + maxTaskAttempts + ").");
        }
    }

    public static String encodeAppShuffleIdentifier(int appShuffleId, TaskContext context) {
        return appShuffleId + "-" + context.stageId() + "-" + context.stageAttemptNumber();
    }

    public static String[] decodeAppShuffleIdentifier(String appShuffleIdentifier) {
        return appShuffleIdentifier.split("-");
    }

    public static int getEncodedAttemptNumber(TaskContext context) {
        return context.stageAttemptNumber() << 16 | context.attemptNumber();
    }

    public static void throwSparkOutOfMemoryError() {
        try {
            throw (SparkOutOfMemoryError)((Object)DynConstructors.builder().impl(SparkOutOfMemoryError.class, String.class).build().newInstance("Not enough memory to grow pointer array"));
        }
        catch (RuntimeException e) {
            DynMethods.StaticMethod isValidErrorClassMethod = DynMethods.builder("isValidErrorClass").impl("org.apache.spark.SparkThrowableHelper", String.class).buildStatic();
            if (((Boolean)isValidErrorClassMethod.invoke("POINTER_ARRAY_OUT_OF_MEMORY")).booleanValue()) {
                throw (SparkOutOfMemoryError)((Object)DynConstructors.builder().impl(SparkOutOfMemoryError.class, String.class, Map.class).build().newInstance("POINTER_ARRAY_OUT_OF_MEMORY", Collections.EMPTY_MAP));
            }
            if (((Boolean)isValidErrorClassMethod.invoke("_LEGACY_ERROR_TEMP_3301")).booleanValue()) {
                throw (SparkOutOfMemoryError)((Object)DynConstructors.builder().impl(SparkOutOfMemoryError.class, String.class, Map.class).build().newInstance("_LEGACY_ERROR_TEMP_3301", Collections.EMPTY_MAP));
            }
            throw new OutOfMemoryError("Unable to construct a SparkOutOfMemoryError, please report this bug to the corresponding communities or vendors, and provide the full stack trace.");
        }
    }
}

