/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.shuffle.celeborn.ShuffleFallbackPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShufflePartitionsFallbackPolicy
implements ShuffleFallbackPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ShufflePartitionsFallbackPolicy.class);
    public static final ShufflePartitionsFallbackPolicy INSTANCE = new ShufflePartitionsFallbackPolicy();

    @Override
    public boolean needFallback(ShuffleDependency<?, ?, ?> shuffleDependency, CelebornConf celebornConf, LifecycleManager lifecycleManager) {
        long numPartitionsThreshold;
        boolean needFallback;
        int numPartitions = shuffleDependency.partitioner().numPartitions();
        boolean bl = needFallback = (long)numPartitions >= (numPartitionsThreshold = celebornConf.shuffleFallbackPartitionThreshold());
        if (needFallback) {
            LOG.warn("Shuffle partition number {} exceeds threshold {}, fallback to spark built-in shuffle implementation.", (Object)numPartitions, (Object)numPartitionsThreshold);
        }
        return needFallback;
    }
}

