/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.metric;

import org.apache.celeborn.plugin.flink.metric.RequestedMemoryUsageMetric;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.util.Preconditions;

public class RemoteShuffleMetricFactory {
    private static final String METRIC_TOTAL_MEMORY_SEGMENT = "TotalMemorySegments";
    private static final String METRIC_TOTAL_MEMORY = "TotalMemory";
    private static final String METRIC_AVAILABLE_MEMORY_SEGMENT = "AvailableMemorySegments";
    private static final String METRIC_AVAILABLE_MEMORY = "AvailableMemory";
    private static final String METRIC_USED_MEMORY_SEGMENT = "UsedMemorySegments";
    private static final String METRIC_USED_MEMORY = "UsedMemory";
    public static final String METRIC_REQUESTED_MEMORY_USAGE = "RequestedMemoryUsage";
    public static final String METRIC_GROUP_SHUFFLE = "Shuffle";
    public static final String METRIC_GROUP_REMOTE = "Remote";

    private RemoteShuffleMetricFactory() {
    }

    public static void registerShuffleMetrics(MetricGroup metricGroup, NetworkBufferPool networkBufferPool) {
        Preconditions.checkNotNull((Object)metricGroup);
        Preconditions.checkNotNull((Object)networkBufferPool);
        RemoteShuffleMetricFactory.internalRegisterShuffleMetrics(metricGroup, networkBufferPool);
    }

    private static void internalRegisterShuffleMetrics(MetricGroup metricGroup, NetworkBufferPool networkBufferPool) {
        MetricGroup networkGroup = metricGroup.addGroup(METRIC_GROUP_SHUFFLE).addGroup(METRIC_GROUP_REMOTE);
        networkGroup.gauge(METRIC_TOTAL_MEMORY_SEGMENT, () -> ((NetworkBufferPool)networkBufferPool).getTotalNumberOfMemorySegments());
        networkGroup.gauge(METRIC_TOTAL_MEMORY, () -> ((NetworkBufferPool)networkBufferPool).getTotalMemory());
        networkGroup.gauge(METRIC_AVAILABLE_MEMORY_SEGMENT, () -> ((NetworkBufferPool)networkBufferPool).getNumberOfAvailableMemorySegments());
        networkGroup.gauge(METRIC_AVAILABLE_MEMORY, () -> ((NetworkBufferPool)networkBufferPool).getAvailableMemory());
        networkGroup.gauge(METRIC_USED_MEMORY_SEGMENT, () -> ((NetworkBufferPool)networkBufferPool).getNumberOfUsedMemorySegments());
        networkGroup.gauge(METRIC_USED_MEMORY, () -> ((NetworkBufferPool)networkBufferPool).getUsedMemory());
        networkGroup.gauge(METRIC_REQUESTED_MEMORY_USAGE, (Gauge)new RequestedMemoryUsageMetric(networkBufferPool));
    }

    public static MetricGroup createShuffleIOOwnerMetricGroup(MetricGroup parentGroup) {
        return parentGroup.addGroup(METRIC_GROUP_SHUFFLE).addGroup(METRIC_GROUP_REMOTE);
    }
}

