/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.plugin.flink.FlinkResultPartitionInfo;
import org.apache.celeborn.plugin.flink.RemoteShuffleDescriptor;
import org.apache.celeborn.plugin.flink.RemoteShuffleResource;
import org.apache.celeborn.plugin.flink.ShuffleResourceDescriptor;
import org.apache.celeborn.plugin.flink.ShuffleResourceTracker;
import org.apache.celeborn.plugin.flink.ShuffleTaskInfo;
import org.apache.celeborn.plugin.flink.fallback.ShuffleFallbackPolicy;
import org.apache.celeborn.plugin.flink.fallback.ShuffleFallbackPolicyRunner;
import org.apache.celeborn.plugin.flink.utils.FlinkUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.io.network.NettyShuffleServiceFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.NettyShuffleMaster;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMasterContext;
import org.apache.flink.runtime.shuffle.TaskInputsOutputsDescriptor;
import org.apache.flink.util.ExecutorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteShuffleMaster
implements ShuffleMaster<ShuffleDescriptor> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteShuffleMaster.class);
    private final CelebornConf conf;
    private final ShuffleMasterContext shuffleMasterContext;
    private final Map<JobID, Set<Integer>> jobShuffleIds = JavaUtils.newConcurrentHashMap();
    private final ConcurrentHashMap<JobID, String> jobFallbackPolicies = JavaUtils.newConcurrentHashMap();
    private String celebornAppId;
    private volatile LifecycleManager lifecycleManager;
    private final ShuffleTaskInfo shuffleTaskInfo = new ShuffleTaskInfo();
    private ShuffleResourceTracker shuffleResourceTracker;
    private final ScheduledExecutorService executor = ThreadUtils.newDaemonSingleThreadScheduledExecutor("celeborn-client-remote-shuffle-master-executor");
    private final long lifecycleManagerTimestamp;
    private final NettyShuffleServiceFactory nettyShuffleServiceFactory;
    private volatile NettyShuffleMaster nettyShuffleMaster;

    public RemoteShuffleMaster(ShuffleMasterContext shuffleMasterContext, @Nullable NettyShuffleServiceFactory nettyShuffleServiceFactory) {
        Configuration configuration = shuffleMasterContext.getConfiguration();
        this.checkShuffleConfig(configuration);
        this.conf = FlinkUtils.toCelebornConf(configuration);
        this.shuffleMasterContext = shuffleMasterContext;
        this.lifecycleManagerTimestamp = System.currentTimeMillis();
        this.nettyShuffleServiceFactory = nettyShuffleServiceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void registerJob(JobShuffleContext context) {
        JobID jobID = context.getJobId();
        LOG.info("Register job: {}.", (Object)jobID);
        if (this.lifecycleManager == null) {
            Class<RemoteShuffleMaster> clazz = RemoteShuffleMaster.class;
            // MONITORENTER : org.apache.celeborn.plugin.flink.RemoteShuffleMaster.class
            if (this.lifecycleManager == null) {
                this.celebornAppId = FlinkUtils.toCelebornAppId(this.lifecycleManagerTimestamp, jobID);
                LOG.info("CelebornAppId: {}", (Object)this.celebornAppId);
                this.lifecycleManager = new LifecycleManager(this.celebornAppId, this.conf);
                this.shuffleResourceTracker = new ShuffleResourceTracker(this.executor, this.lifecycleManager);
            }
            // MONITOREXIT : clazz
        }
        this.lifecycleManager.applicationCount().increment();
        try {
            Optional<ShuffleFallbackPolicy> shuffleFallbackPolicy;
            if (this.nettyShuffleServiceFactory != null && (shuffleFallbackPolicy = ShuffleFallbackPolicyRunner.getActivatedFallbackPolicy(context, this.conf, this.lifecycleManager)).isPresent()) {
                LOG.warn("Fallback to vanilla Flink NettyShuffleMaster for job: {}.", (Object)jobID);
                String jobFallbackPolicy = shuffleFallbackPolicy.get().getClass().getName();
                this.jobFallbackPolicies.put(jobID, jobFallbackPolicy);
                this.lifecycleManager.computeFallbackCounts(this.lifecycleManager.applicationFallbackCounts(), jobFallbackPolicy);
                this.nettyShuffleMaster().registerJob(context);
                return;
            }
            Set previousShuffleIds = this.jobShuffleIds.putIfAbsent(jobID, new HashSet());
            if (previousShuffleIds != null) {
                throw new RuntimeException("Duplicated registration job: " + jobID);
            }
            this.shuffleResourceTracker.registerJob(context);
            return;
        }
        catch (CelebornIOException e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterJob(JobID jobID) {
        LOG.info("Unregister job: {}.", (Object)jobID);
        if (this.jobFallbackPolicies.remove(jobID) != null) {
            this.nettyShuffleMaster().unregisterJob(jobID);
            return;
        }
        Set<Integer> shuffleIds = this.jobShuffleIds.remove(jobID);
        if (shuffleIds != null) {
            this.executor.execute(() -> {
                try {
                    for (Integer shuffleId : shuffleIds) {
                        this.lifecycleManager.unregisterShuffle(shuffleId);
                        this.shuffleTaskInfo.removeExpiredShuffle(shuffleId);
                    }
                    this.shuffleResourceTracker.unRegisterJob(jobID);
                }
                catch (Throwable throwable) {
                    LOG.error("Encounter an error when unregistering job: {}.", (Object)jobID, (Object)throwable);
                }
            });
        }
    }

    public CompletableFuture<ShuffleDescriptor> registerPartitionWithProducer(JobID jobID, PartitionDescriptor partitionDescriptor, ProducerDescriptor producerDescriptor) {
        return CompletableFuture.supplyAsync(() -> {
            this.lifecycleManager.shuffleCount().increment();
            String jobFallbackPolicy = this.jobFallbackPolicies.get(jobID);
            if (jobFallbackPolicy != null) {
                try {
                    this.lifecycleManager.computeFallbackCounts(this.lifecycleManager.shuffleFallbackCounts(), jobFallbackPolicy);
                    return (ShuffleDescriptor)this.nettyShuffleMaster().registerPartitionWithProducer(jobID, partitionDescriptor, producerDescriptor).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            Set<Integer> shuffleIds = this.jobShuffleIds.get(jobID);
            if (shuffleIds == null) {
                throw new RuntimeException("Can not find job in lifecycleManager, job: " + jobID);
            }
            FlinkResultPartitionInfo resultPartitionInfo = new FlinkResultPartitionInfo(jobID, partitionDescriptor, producerDescriptor);
            ShuffleResourceDescriptor shuffleResourceDescriptor = this.shuffleTaskInfo.genShuffleResourceDescriptor(resultPartitionInfo.getShuffleId(), resultPartitionInfo.getTaskId(), resultPartitionInfo.getAttemptId());
            Set<Integer> set = shuffleIds;
            synchronized (set) {
                shuffleIds.add(shuffleResourceDescriptor.getShuffleId());
            }
            RemoteShuffleResource remoteShuffleResource = new RemoteShuffleResource(this.lifecycleManager.getHost(), this.lifecycleManager.getPort(), this.lifecycleManagerTimestamp, shuffleResourceDescriptor);
            this.shuffleResourceTracker.addPartitionResource(jobID, shuffleResourceDescriptor.getShuffleId(), shuffleResourceDescriptor.getPartitionId(), resultPartitionInfo.getResultPartitionId());
            return new RemoteShuffleDescriptor(this.celebornAppId, jobID, resultPartitionInfo.getShuffleId(), resultPartitionInfo.getResultPartitionId(), remoteShuffleResource);
        }, this.executor);
    }

    public void releasePartitionExternally(ShuffleDescriptor shuffleDescriptor) {
        this.executor.execute(() -> {
            if (shuffleDescriptor instanceof RemoteShuffleDescriptor) {
                try {
                    RemoteShuffleDescriptor descriptor = (RemoteShuffleDescriptor)shuffleDescriptor;
                    RemoteShuffleResource shuffleResource = descriptor.getShuffleResource();
                    ShuffleResourceDescriptor resourceDescriptor = shuffleResource.getMapPartitionShuffleDescriptor();
                    LOG.debug("release partition resource: {}.", (Object)resourceDescriptor);
                    this.lifecycleManager.releasePartition(resourceDescriptor.getShuffleId(), resourceDescriptor.getPartitionId());
                    this.shuffleResourceTracker.removePartitionResource(descriptor.getJobId(), resourceDescriptor.getShuffleId(), resourceDescriptor.getPartitionId());
                }
                catch (Throwable throwable) {
                    LOG.debug("Failed to release data partition {}.", (Object)shuffleDescriptor, (Object)throwable);
                }
            } else if (shuffleDescriptor instanceof NettyShuffleDescriptor) {
                this.nettyShuffleMaster().releasePartitionExternally(shuffleDescriptor);
            } else {
                LOG.error("Unsupported shuffle descriptor {}. Only supports {} and {}", new Object[]{shuffleDescriptor.getClass().getName(), RemoteShuffleDescriptor.class.getName(), NettyShuffleDescriptor.class.getName()});
                this.shuffleMasterContext.onFatalError((Throwable)new RuntimeException("Illegal shuffle descriptor type."));
            }
        });
    }

    public MemorySize computeShuffleMemorySizeForTask(TaskInputsOutputsDescriptor taskInputsOutputsDescriptor) {
        for (ResultPartitionType partitionType : taskInputsOutputsDescriptor.getPartitionTypes().values()) {
            boolean isBlockingShuffle = partitionType.isBlockingOrBlockingPersistentResultPartition();
            if (isBlockingShuffle) continue;
            throw new RuntimeException("Blocking result partition type expected but found " + partitionType);
        }
        int numResultPartitions = taskInputsOutputsDescriptor.getSubpartitionNums().size();
        long numBytesPerPartition = this.conf.clientFlinkMemoryPerResultPartition();
        long numBytesForOutput = numBytesPerPartition * (long)numResultPartitions;
        int numInputGates = taskInputsOutputsDescriptor.getInputChannelNums().size();
        long numBytesPerGate = this.conf.clientFlinkMemoryPerInputGate();
        long numBytesForInput = numBytesPerGate * (long)numInputGates;
        LOG.debug("Announcing number of bytes {} for output and {} for input.", (Object)numBytesForOutput, (Object)numBytesForInput);
        return new MemorySize(numBytesForInput + numBytesForOutput);
    }

    public void close() throws Exception {
        try {
            this.jobFallbackPolicies.clear();
            this.jobShuffleIds.clear();
            LifecycleManager manager = this.lifecycleManager;
            if (null != manager) {
                manager.stop();
            }
            if (this.nettyShuffleMaster != null) {
                this.nettyShuffleMaster.close();
                this.nettyShuffleMaster = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Encounter exception when shutdown: {}", (Object)e.getMessage(), (Object)e);
        }
        ExecutorUtils.gracefulShutdown((long)10L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{this.executor});
    }

    private void checkShuffleConfig(Configuration configuration) {
        if (configuration.get(ExecutionOptions.BATCH_SHUFFLE_MODE) != BatchShuffleMode.ALL_EXCHANGES_BLOCKING) {
            throw new IllegalArgumentException(String.format("The config option %s should configure as %s", ExecutionOptions.BATCH_SHUFFLE_MODE.key(), BatchShuffleMode.ALL_EXCHANGES_BLOCKING.name()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NettyShuffleMaster nettyShuffleMaster() {
        if (this.nettyShuffleMaster == null) {
            RemoteShuffleMaster remoteShuffleMaster = this;
            synchronized (remoteShuffleMaster) {
                if (this.nettyShuffleMaster == null) {
                    this.nettyShuffleMaster = this.nettyShuffleServiceFactory.createShuffleMaster(this.shuffleMasterContext);
                }
            }
        }
        return this.nettyShuffleMaster;
    }

    @VisibleForTesting
    public LifecycleManager lifecycleManager() {
        return this.lifecycleManager;
    }

    @VisibleForTesting
    public ConcurrentHashMap<JobID, String> jobFallbackPolicies() {
        return this.jobFallbackPolicies;
    }
}

