/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class SerializedExceptionPBImpl
extends SerializedException {
    YarnProtos.SerializedExceptionProto proto = null;
    YarnProtos.SerializedExceptionProto.Builder builder = YarnProtos.SerializedExceptionProto.newBuilder();
    boolean viaProto = false;

    public SerializedExceptionPBImpl() {
    }

    public SerializedExceptionPBImpl(YarnProtos.SerializedExceptionProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private SerializedExceptionPBImpl(Throwable t) {
        this.init(t);
    }

    @Override
    public void init(String message) {
        this.maybeInitBuilder();
        this.builder.setMessage(message);
    }

    @Override
    public void init(Throwable t) {
        this.maybeInitBuilder();
        if (t == null) {
            return;
        }
        if (t.getCause() != null) {
            this.builder.setCause(new SerializedExceptionPBImpl(t.getCause()).getProto());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        if (sw.toString() != null) {
            this.builder.setTrace(sw.toString());
        }
        if (t.getMessage() != null) {
            this.builder.setMessage(t.getMessage());
        }
        this.builder.setClassName(t.getClass().getCanonicalName());
    }

    @Override
    public void init(String message, Throwable t) {
        this.init(t);
        if (message != null) {
            this.builder.setMessage(message);
        }
    }

    @Override
    public Throwable deSerialize() {
        SerializedException cause = this.getCause();
        YarnProtos.SerializedExceptionProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        Class<?> realClass = null;
        try {
            realClass = Class.forName(p.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException(e);
        }
        Class classType = null;
        classType = YarnException.class.isAssignableFrom(realClass) ? YarnException.class : (IOException.class.isAssignableFrom(realClass) ? IOException.class : (RuntimeException.class.isAssignableFrom(realClass) ? RuntimeException.class : Throwable.class));
        return SerializedExceptionPBImpl.instantiateException(realClass.asSubclass(classType), this.getMessage(), cause == null ? null : cause.deSerialize());
    }

    @Override
    public String getMessage() {
        YarnProtos.SerializedExceptionProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getMessage();
    }

    @Override
    public String getRemoteTrace() {
        YarnProtos.SerializedExceptionProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getTrace();
    }

    @Override
    public SerializedException getCause() {
        YarnProtos.SerializedExceptionProtoOrBuilder p;
        YarnProtos.SerializedExceptionProtoOrBuilder serializedExceptionProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (p.hasCause()) {
            return new SerializedExceptionPBImpl(p.getCause());
        }
        return null;
    }

    public YarnProtos.SerializedExceptionProto getProto() {
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((SerializedExceptionPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.SerializedExceptionProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private static <T extends Throwable> T instantiateExceptionImpl(String message, Class<? extends T> cls, Throwable cause) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] classArray;
        Throwable ex = null;
        if (message == null) {
            classArray = new Class[]{};
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = String.class;
        }
        Constructor<T> cn = cls.getConstructor(classArray);
        cn.setAccessible(true);
        ex = message == null ? (Throwable)cn.newInstance(new Object[0]) : (Throwable)cn.newInstance(message);
        ex.initCause(cause);
        return (T)ex;
    }

    private static <T extends Throwable> T instantiateException(Class<? extends T> cls, String message, Throwable cause) {
        T ex = null;
        try {
            try {
                ex = SerializedExceptionPBImpl.instantiateExceptionImpl(message, cls, cause);
            }
            catch (NoSuchMethodException e) {
                ex = SerializedExceptionPBImpl.instantiateExceptionImpl(null, cls, cause);
            }
        }
        catch (SecurityException e) {
            throw new YarnRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new YarnRuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new YarnRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new YarnRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new YarnRuntimeException(e);
        }
        return ex;
    }
}

