/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ratis.netty.NettyUtils;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpcWithProxy;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufDecoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufEncoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LoggingHandler;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyRpcService
extends RaftServerRpcWithProxy<NettyRpcProxy, NettyRpcProxy.PeerMap> {
    public static final Logger LOG = LoggerFactory.getLogger(NettyRpcService.class);
    static final String CLASS_NAME = JavaUtils.getClassSimpleName(NettyRpcService.class);
    public static final String SEND_SERVER_REQUEST = CLASS_NAME + ".sendServerRequest";
    private final RaftServer server;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final MemoizedSupplier<ChannelFuture> channel;
    private final InetSocketAddress socketAddress;

    public static Builder newBuilder() {
        return new Builder();
    }

    private NettyRpcService(RaftServer server) {
        super(() -> ((RaftServer)server).getId(), id -> new NettyRpcProxy.PeerMap(id.toString(), server.getProperties()));
        this.server = server;
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
                p.addLast(new ChannelHandler[]{new ProtobufDecoder((MessageLite)NettyProtos.RaftNettyServerRequestProto.getDefaultInstance())});
                p.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
                p.addLast(new ChannelHandler[]{new ProtobufEncoder()});
                p.addLast(new ChannelHandler[]{new InboundHandler()});
            }
        };
        boolean useEpoll = NettyConfigKeys.Server.useEpoll(server.getProperties());
        this.bossGroup = NettyUtils.newEventLoopGroup(CLASS_NAME + "-bossGroup", 0, useEpoll);
        this.workerGroup = NettyUtils.newEventLoopGroup(CLASS_NAME + "-workerGroup", 0, useEpoll);
        String host = NettyConfigKeys.Server.host(server.getProperties());
        int port = NettyConfigKeys.Server.port(server.getProperties());
        this.socketAddress = host == null || host.isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        this.channel = JavaUtils.memoize(() -> this.lambda$new$1((ChannelInitializer)initializer));
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.NETTY;
    }

    private Channel getChannel() {
        if (!this.channel.isInitialized()) {
            throw new IllegalStateException(this.getId() + ": Failed to getChannel since the service is not yet started");
        }
        return ((ChannelFuture)this.channel.get()).awaitUninterruptibly().channel();
    }

    public void startImpl() throws IOException {
        try {
            ((ChannelFuture)this.channel.get()).syncUninterruptibly();
        }
        catch (Exception t) {
            throw new IOException(this.getId() + ": Failed to start " + JavaUtils.getClassSimpleName(((Object)((Object)this)).getClass()), t);
        }
    }

    public void closeImpl() throws IOException {
        ChannelFuture f = this.getChannel().close();
        f.syncUninterruptibly();
        this.bossGroup.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS);
        this.workerGroup.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS);
        try {
            this.bossGroup.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            this.workerGroup.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupt EventLoopGroup terminate", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        super.closeImpl();
    }

    public InetSocketAddress getInetSocketAddress() {
        try {
            return (InetSocketAddress)this.getChannel().localAddress();
        }
        catch (IllegalStateException e) {
            if (this.socketAddress.getPort() != 0) {
                return this.socketAddress;
            }
            throw e;
        }
    }

    NettyProtos.RaftNettyServerReplyProto handle(NettyProtos.RaftNettyServerRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpcRequest = null;
        try {
            switch (proto.getRaftNettyServerRequestCase()) {
                case REQUESTVOTEREQUEST: {
                    RaftProtos.RequestVoteRequestProto request = proto.getRequestVoteRequest();
                    rpcRequest = request.getServerRequest();
                    RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRequestVoteReply(reply).build();
                }
                case TRANSFERLEADERSHIPREQUEST: {
                    RaftProtos.TransferLeadershipRequestProto transferLeadershipRequest = proto.getTransferLeadershipRequest();
                    rpcRequest = transferLeadershipRequest.getRpcRequest();
                    RaftClientReply transferLeadershipReply = this.server.transferLeadership(ClientProtoUtils.toTransferLeadershipRequest((RaftProtos.TransferLeadershipRequestProto)transferLeadershipRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)transferLeadershipReply)).build();
                }
                case STARTLEADERELECTIONREQUEST: {
                    RaftProtos.StartLeaderElectionRequestProto startLeaderElectionRequest = proto.getStartLeaderElectionRequest();
                    rpcRequest = startLeaderElectionRequest.getServerRequest();
                    RaftProtos.StartLeaderElectionReplyProto startLeaderElectionReply = this.server.startLeaderElection(startLeaderElectionRequest);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setStartLeaderElectionReply(startLeaderElectionReply).build();
                }
                case SNAPSHOTMANAGEMENTREQUEST: {
                    RaftProtos.SnapshotManagementRequestProto snapshotManagementRequest = proto.getSnapshotManagementRequest();
                    rpcRequest = snapshotManagementRequest.getRpcRequest();
                    RaftClientReply snapshotManagementReply = this.server.snapshotManagement(ClientProtoUtils.toSnapshotManagementRequest((RaftProtos.SnapshotManagementRequestProto)snapshotManagementRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)snapshotManagementReply)).build();
                }
                case LEADERELECTIONMANAGEMENTREQUEST: {
                    RaftProtos.LeaderElectionManagementRequestProto leaderElectionManagementRequest = proto.getLeaderElectionManagementRequest();
                    rpcRequest = leaderElectionManagementRequest.getRpcRequest();
                    RaftClientReply leaderElectionManagementReply = this.server.leaderElectionManagement(ClientProtoUtils.toLeaderElectionManagementRequest((RaftProtos.LeaderElectionManagementRequestProto)leaderElectionManagementRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)leaderElectionManagementReply)).build();
                }
                case APPENDENTRIESREQUEST: {
                    RaftProtos.AppendEntriesRequestProto appendEntriesRequest = proto.getAppendEntriesRequest();
                    rpcRequest = appendEntriesRequest.getServerRequest();
                    RaftProtos.AppendEntriesReplyProto appendEntriesReply = this.server.appendEntries(appendEntriesRequest);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setAppendEntriesReply(appendEntriesReply).build();
                }
                case INSTALLSNAPSHOTREQUEST: {
                    RaftProtos.InstallSnapshotRequestProto installSnapshotRequest = proto.getInstallSnapshotRequest();
                    rpcRequest = installSnapshotRequest.getServerRequest();
                    RaftProtos.InstallSnapshotReplyProto installSnapshotReply = this.server.installSnapshot(installSnapshotRequest);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setInstallSnapshotReply(installSnapshotReply).build();
                }
                case RAFTCLIENTREQUEST: {
                    RaftProtos.RaftClientRequestProto raftClientRequest = proto.getRaftClientRequest();
                    rpcRequest = raftClientRequest.getRpcRequest();
                    RaftClientReply raftClientReply = this.server.submitClientRequest(ClientProtoUtils.toRaftClientRequest((RaftProtos.RaftClientRequestProto)raftClientRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)raftClientReply)).build();
                }
                case SETCONFIGURATIONREQUEST: {
                    RaftProtos.SetConfigurationRequestProto configurationRequest = proto.getSetConfigurationRequest();
                    rpcRequest = configurationRequest.getRpcRequest();
                    RaftClientReply configurationReply = this.server.setConfiguration(ClientProtoUtils.toSetConfigurationRequest((RaftProtos.SetConfigurationRequestProto)configurationRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)configurationReply)).build();
                }
                case GROUPMANAGEMENTREQUEST: {
                    RaftProtos.GroupManagementRequestProto groupManagementRequest = proto.getGroupManagementRequest();
                    rpcRequest = groupManagementRequest.getRpcRequest();
                    RaftClientReply groupManagementReply = this.server.groupManagement(ClientProtoUtils.toGroupManagementRequest((RaftProtos.GroupManagementRequestProto)groupManagementRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)groupManagementReply)).build();
                }
                case GROUPLISTREQUEST: {
                    RaftProtos.GroupListRequestProto groupListRequest = proto.getGroupListRequest();
                    rpcRequest = groupListRequest.getRpcRequest();
                    GroupListReply groupListReply = this.server.getGroupList(ClientProtoUtils.toGroupListRequest((RaftProtos.GroupListRequestProto)groupListRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setGroupListReply(ClientProtoUtils.toGroupListReplyProto((GroupListReply)groupListReply)).build();
                }
                case GROUPINFOREQUEST: {
                    RaftProtos.GroupInfoRequestProto groupInfoRequest = proto.getGroupInfoRequest();
                    rpcRequest = groupInfoRequest.getRpcRequest();
                    GroupInfoReply groupInfoReply = this.server.getGroupInfo(ClientProtoUtils.toGroupInfoRequest((RaftProtos.GroupInfoRequestProto)groupInfoRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setGroupInfoReply(ClientProtoUtils.toGroupInfoReplyProto((GroupInfoReply)groupInfoReply)).build();
                }
                case RAFTNETTYSERVERREQUEST_NOT_SET: {
                    throw new IllegalArgumentException("Request case not set in proto: " + proto.getRaftNettyServerRequestCase());
                }
            }
            throw new UnsupportedOperationException("Request case not supported: " + proto.getRaftNettyServerRequestCase());
        }
        catch (IOException ioe) {
            return NettyRpcService.toRaftNettyServerReplyProto(Objects.requireNonNull(rpcRequest, "rpcRequest = null"), ioe);
        }
    }

    private static NettyProtos.RaftNettyServerReplyProto toRaftNettyServerReplyProto(RaftProtos.RaftRpcRequestProto request, IOException e) {
        RaftProtos.RaftRpcReplyProto.Builder rpcReply = RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(request.getRequestorId()).setReplyId(request.getReplyId()).setCallId(request.getCallId()).setSuccess(false);
        NettyProtos.RaftNettyExceptionReplyProto.Builder ioe = NettyProtos.RaftNettyExceptionReplyProto.newBuilder().setRpcReply(rpcReply).setException(ProtoUtils.writeObject2ByteString((Object)e));
        return NettyProtos.RaftNettyServerReplyProto.newBuilder().setExceptionReply(ioe).build();
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setRequestVoteRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getRequestVoteReply();
    }

    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setStartLeaderElectionRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getStartLeaderElectionReply();
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setAppendEntriesRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getAppendEntriesReply();
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        CodeInjectionForTesting.execute((String)SEND_SERVER_REQUEST, (Object)this.getId(), null, (Object[])new Object[]{request});
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setInstallSnapshotRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getInstallSnapshotReply();
    }

    private NettyProtos.RaftNettyServerReplyProto sendRaftNettyServerRequestProto(RaftProtos.RaftRpcRequestProto request, NettyProtos.RaftNettyServerRequestProto proto) throws IOException {
        RaftPeerId id = RaftPeerId.valueOf((ByteString)request.getReplyId());
        try {
            NettyRpcProxy p = (NettyRpcProxy)((NettyRpcProxy.PeerMap)this.getProxies()).getProxy(id);
            return p.send(request, proto);
        }
        catch (Exception e) {
            ((NettyRpcProxy.PeerMap)this.getProxies()).handleException(id, e, false);
            throw e;
        }
    }

    private /* synthetic */ ChannelFuture lambda$new$1(ChannelInitializer initializer) {
        return ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NettyUtils.getServerChannelClass(this.bossGroup))).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)initializer).bind((SocketAddress)this.socketAddress);
    }

    @ChannelHandler.Sharable
    class InboundHandler
    extends SimpleChannelInboundHandler<NettyProtos.RaftNettyServerRequestProto> {
        InboundHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, NettyProtos.RaftNettyServerRequestProto proto) {
            NettyProtos.RaftNettyServerReplyProto reply = NettyRpcService.this.handle(proto);
            ctx.writeAndFlush((Object)reply);
        }
    }

    public static final class Builder {
        private RaftServer server;

        private Builder() {
        }

        public Builder setServer(RaftServer raftServer) {
            this.server = raftServer;
            return this;
        }

        public NettyRpcService build() {
            return new NettyRpcService(this.server);
        }
    }
}

