/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcMetricsTracker;
import org.apache.celeborn.common.rpc.ThreadSafeRpcEndpoint;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.NettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.OnStart$;
import org.apache.celeborn.common.rpc.netty.OnStop$;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.apache.celeborn.common.rpc.netty.RpcTimeMetrics$;
import org.apache.celeborn.common.rpc.netty.RpcTimeMetrics$Dequeue$;
import org.apache.celeborn.common.rpc.netty.RpcTimeMetrics$Enqueue$;
import org.apache.celeborn.common.rpc.netty.RpcTimeMetrics$Process$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg!B\u0001\u0003\u0001!q!!B%oE>D(BA\u0002\u0005\u0003\u0015qW\r\u001e;z\u0015\t)a!A\u0002sa\u000eT!a\u0002\u0005\u0002\r\r|W.\\8o\u0015\tI!\"\u0001\u0005dK2,'m\u001c:o\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0014\u0007\u0001yQ\u0003\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-ei\u0011a\u0006\u0006\u00031\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00035]\u0011q\u0001T8hO&tw\r\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003-)g\u000e\u001a9pS:$(+\u001a4\u0004\u0001U\tq\u0004\u0005\u0002!C5\t!!\u0003\u0002#\u0005\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\"AA\u0005\u0001B\u0001B\u0003%q$\u0001\u0007f]\u0012\u0004x.\u001b8u%\u00164\u0007\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001(\u0003!)g\u000e\u001a9pS:$X#\u0001\u0015\u0011\u0005%RS\"\u0001\u0003\n\u0005-\"!a\u0003*qG\u0016sG\r]8j]RD\u0001\"\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\nK:$\u0007o\\5oi\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\u0005G>tg-F\u00012!\t\u00114'D\u0001\u0007\u0013\t!dA\u0001\u0007DK2,'m\u001c:o\u0007>tg\r\u0003\u00057\u0001\t\u0005\t\u0015!\u00032\u0003\u0015\u0019wN\u001c4!\u0011!A\u0004A!b\u0001\n\u0003I\u0014aB7fiJL7m]\u000b\u0002uA\u0011\u0011fO\u0005\u0003y\u0011\u0011\u0011C\u00159d\u001b\u0016$(/[2t)J\f7m[3s\u0011!q\u0004A!A!\u0002\u0013Q\u0014\u0001C7fiJL7m\u001d\u0011\t\u000b\u0001\u0003A\u0011A!\u0002\rqJg.\u001b;?)\u0015\u00115\tR#G!\t\u0001\u0003\u0001C\u0003\u001d\u007f\u0001\u0007q\u0004C\u0003'\u007f\u0001\u0007\u0001\u0006C\u00030\u007f\u0001\u0007\u0011\u0007C\u00039\u007f\u0001\u0007!\b\u0003\u0005I\u0001\t\u0007I\u0011\u0001\u0002J\u0003!\u0019\u0017\r]1dSRLX#\u0001&\u0011\u0005AY\u0015B\u0001'\u0012\u0005\rIe\u000e\u001e\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002&\u0002\u0013\r\f\u0007/Y2jif\u0004\u0003\u0002\u0003)\u0001\u0005\u0004%\tAA)\u0002\u0013%t'm\u001c=M_\u000e\\W#\u0001*\u0011\u0005McV\"\u0001+\u000b\u0005U3\u0016!\u00027pG.\u001c(BA,Y\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u00033j\u000bA!\u001e;jY*\t1,\u0001\u0003kCZ\f\u0017BA/U\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\"1q\f\u0001Q\u0001\nI\u000b!\"\u001b8c_bdunY6!\u0011!\t\u0007A1A\u0005\u0002\t\u0011\u0017AB5t\rVdG.F\u0001d!\t\u0019F-\u0003\u0002f)\nI1i\u001c8eSRLwN\u001c\u0005\u0007O\u0002\u0001\u000b\u0011B2\u0002\u000f%\u001ch)\u001e7mA!9\u0011\u000e\u0001b\u0001\n#Q\u0017\u0001C7fgN\fw-Z:\u0016\u0003-\u00042\u0001\\7p\u001b\u0005A\u0016B\u00018Y\u0005)a\u0015N\\6fI2K7\u000f\u001e\t\u0003AAL!!\u001d\u0002\u0003\u0019%s'm\u001c=NKN\u001c\u0018mZ3\t\rM\u0004\u0001\u0015!\u0003l\u0003%iWm]:bO\u0016\u001c\b\u0005\u000b\u0003skz|\bC\u0001<}\u001b\u00059(BA,y\u0015\tI(0\u0001\u0006b]:|G/\u0019;j_:T\u0011a_\u0001\u0006U\u00064\u0018\r_\u0005\u0003{^\u0014\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0005\u0005\u0005\u0011\u0001\u0002;iSND\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\u0002\u00195,7o]1hK\u000e{WO\u001c;\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=a+\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003'\tiA\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD\u0001\"a\u0006\u0001A\u0003%\u0011\u0011B\u0001\u000e[\u0016\u001c8/Y4f\u0007>,h\u000e\u001e\u0011\t\u0013\u0005m\u0001\u00011A\u0005\n\u0005u\u0011aB:u_B\u0004X\rZ\u000b\u0003\u0003?\u00012\u0001EA\u0011\u0013\r\t\u0019#\u0005\u0002\b\u0005>|G.Z1o\u0011%\t9\u0003\u0001a\u0001\n\u0013\tI#A\u0006ti>\u0004\b/\u001a3`I\u0015\fH\u0003BA\u0016\u0003c\u00012\u0001EA\u0017\u0013\r\ty#\u0005\u0002\u0005+:LG\u000f\u0003\u0006\u00024\u0005\u0015\u0012\u0011!a\u0001\u0003?\t1\u0001\u001f\u00132\u0011!\t9\u0004\u0001Q!\n\u0005}\u0011\u0001C:u_B\u0004X\r\u001a\u0011)\u000b\u0005URO`@\t\u0013\u0005u\u0002\u00011A\u0005\n\u0005u\u0011\u0001E3oC\ndWmQ8oGV\u0014(/\u001a8u\u0011%\t\t\u0005\u0001a\u0001\n\u0013\t\u0019%\u0001\u000bf]\u0006\u0014G.Z\"p]\u000e,(O]3oi~#S-\u001d\u000b\u0005\u0003W\t)\u0005\u0003\u0006\u00024\u0005}\u0012\u0011!a\u0001\u0003?A\u0001\"!\u0013\u0001A\u0003&\u0011qD\u0001\u0012K:\f'\r\\3D_:\u001cWO\u001d:f]R\u0004\u0003&BA$kz|\b\u0002CA(\u0001\u0001\u0007I\u0011B%\u0002!9,X.Q2uSZ,G\u000b\u001b:fC\u0012\u001c\b\"CA*\u0001\u0001\u0007I\u0011BA+\u0003QqW/\\!di&4X\r\u00165sK\u0006$7o\u0018\u0013fcR!\u00111FA,\u0011%\t\u0019$!\u0015\u0002\u0002\u0003\u0007!\nC\u0004\u0002\\\u0001\u0001\u000b\u0015\u0002&\u0002#9,X.Q2uSZ,G\u000b\u001b:fC\u0012\u001c\b\u0005K\u0003\u0002ZUtx\u0010C\u0004\u0002b\u0001!\t!a\u0019\u0002\u0015\u0005$G-T3tg\u0006<W\r\u0006\u0003\u0002,\u0005\u0015\u0004bBA4\u0003?\u0002\ra\\\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\tY\u0007\u0001C\u0005\u0003[\nq\u0002\u001d:pG\u0016\u001c8/\u00138uKJt\u0017\r\u001c\u000b\u0007\u0003W\ty'!\u001f\t\u0011\u0005E\u0014\u0011\u000ea\u0001\u0003g\n!\u0002Z5ta\u0006$8\r[3s!\r\u0001\u0013QO\u0005\u0004\u0003o\u0012!A\u0003#jgB\fGo\u00195fe\"9\u0011qMA5\u0001\u0004y\u0007\u0002CA?\u0001\u0011\u0005!!a \u0002\u0015]\f\u0017\u000e^(o\rVdG\u000e\u0006\u0002\u0002,!9\u00111\u0011\u0001\u0005\n\u0005}\u0014!D:jO:\fGNT8u\rVdG\u000eC\u0004\u0002\b\u0002!\t!!#\u0002\u000fA\u0014xnY3tgR!\u00111FAF\u0011!\t\t(!\"A\u0002\u0005M\u0004bBAH\u0001\u0011\u0005\u0011\u0011S\u0001\u0005a>\u001cH\u000f\u0006\u0003\u0002,\u0005M\u0005bBA4\u0003\u001b\u0003\ra\u001c\u0005\b\u0003/\u0003A\u0011AA@\u0003\u0011\u0019Ho\u001c9\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\u00059\u0011n]#naRL\bbBAP\u0001\u0011E\u0011\u0011U\u0001\u0007_:$%o\u001c9\u0015\t\u0005-\u00121\u0015\u0005\b\u0003O\ni\n1\u0001p\u0011\u001d\t9\u000b\u0001C\u0005\u0003S\u000b!b]1gK2L8)\u00197m)!\tY+a.\u0002:\u0006-G\u0003BA\u0016\u0003[C\u0011\"a,\u0002&\u0012\u0005\r!!-\u0002\r\u0005\u001cG/[8o!\u0015\u0001\u00121WA\u0016\u0013\r\t),\u0005\u0002\ty\tLh.Y7f}!1a%!*A\u0002!B\u0001\"a/\u0002&\u0002\u0007\u0011QX\u0001\u0010K:$\u0007o\\5oiJ+gMT1nKB!\u0011qXAc\u001d\r\u0001\u0012\u0011Y\u0005\u0004\u0003\u0007\f\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0006%'AB*ue&twMC\u0002\u0002DFAq!a\u001a\u0002&\u0002\u0007q\u000e\u0003\u0004\u0002P\u0002!\t!S\u0001\u0014O\u0016$h*^7BGRLg/\u001a+ie\u0016\fGm\u001d")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    private final CelebornConf conf;
    private final RpcMetricsTracker metrics;
    private final int capacity;
    private final ReentrantLock inboxLock;
    private final Condition isFull;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    private final AtomicLong org$apache$celeborn$common$rpc$netty$Inbox$$messageCount;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        Inbox inbox = this;
        synchronized (inbox) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public RpcMetricsTracker metrics() {
        return this.metrics;
    }

    public int capacity() {
        return this.capacity;
    }

    public ReentrantLock inboxLock() {
        return this.inboxLock;
    }

    public Condition isFull() {
        return this.isFull;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    public AtomicLong org$apache$celeborn$common$rpc$netty$Inbox$$messageCount() {
        return this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void addMessage(InboxMessage message) {
        this.messages().add(message);
        this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().incrementAndGet();
        this.signalNotFull();
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Inbox $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"queue length of ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().get())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$celeborn$common$rpc$netty$Inbox$$processInternal(Dispatcher dispatcher, InboxMessage message) {
        InboxMessage inboxMessage = message;
        if (inboxMessage instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)inboxMessage;
            RpcAddress _sender = rpcMessage.senderAddress();
            Object content = rpcMessage.content();
            NettyRpcCallContext context = rpcMessage.context();
            try {
                BoxedUnit boxedUnit2 = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1)new Serializable(this, message, _sender){
                    public static final long serialVersionUID = 0L;
                    private final InboxMessage message$1;
                    private final RpcAddress _sender$1;

                    public final Nothing$ apply(Object msg) {
                        throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported message ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$1, this._sender$1})));
                    }
                    {
                        this.message$1 = message$1;
                        this._sender$1 = _sender$1;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                context.sendFailure(throwable);
                throw throwable;
            }
        }
        if (inboxMessage instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
            RpcAddress _sender = oneWayMessage.senderAddress();
            Object content = oneWayMessage.content();
            BoxedUnit boxedUnit3 = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1)new Serializable(this, message, _sender){
                public static final long serialVersionUID = 0L;
                private final InboxMessage message$1;
                private final RpcAddress _sender$2;

                public final Nothing$ apply(Object msg) {
                    throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported message ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$1, this._sender$2})));
                }
                {
                    this.message$1 = message$1;
                    this._sender$2 = _sender$2;
                }
            });
            return;
        }
        if (OnStart$.MODULE$.equals(inboxMessage)) {
            BoxedUnit boxedUnit;
            this.endpoint().onStart();
            if (this.endpoint() instanceof ThreadSafeRpcEndpoint) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.inboxLock().lockInterruptibly();
                if (!this.stopped()) {
                    this.enableConcurrent_$eq(true);
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
            return;
        }
        if (OnStop$.MODULE$.equals(inboxMessage)) {
            this.inboxLock().lockInterruptibly();
            int activeThreads = this.numActiveThreads();
            Predef$.MODULE$.assert(activeThreads == 1, (Function0)new Serializable(this, activeThreads){
                public static final long serialVersionUID = 0L;
                private final int activeThreads$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be only a single active thread but found ", " threads."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.activeThreads$1)}));
                }
                {
                    this.activeThreads$1 = activeThreads$1;
                }
            });
            dispatcher.removeRpcEndpointRef(this.endpoint());
            this.endpoint().onStop();
            Predef$.MODULE$.assert(this.isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "OnStop should be the last message";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (inboxMessage instanceof RemoteProcessConnected) {
            RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
            RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
            this.endpoint().onConnected(remoteAddress);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (inboxMessage instanceof RemoteProcessDisconnected) {
            RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
            RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
            this.endpoint().onDisconnected(remoteAddress);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!(inboxMessage instanceof RemoteProcessConnectionError)) throw new MatchError((Object)inboxMessage);
        RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
        Throwable cause = remoteProcessConnectionError.cause();
        RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
        this.endpoint().onNetworkError(cause, remoteAddress);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return;
        finally {
            this.inboxLock().unlock();
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public void waitOnFull() {
        if (this.capacity() > 0 && !this.stopped()) {
            this.inboxLock().lockInterruptibly();
            while (this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().get() >= (long)this.capacity()) {
                this.isFull().await();
            }
        }
        return;
        finally {
            this.inboxLock().unlock();
        }
    }

    private void signalNotFull() {
        Predef$.MODULE$.require(this.inboxLock().isHeldByCurrentThread(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "cannot call signalNotFull without holding lock";
            }
        });
        if (this.capacity() > 0 && this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().get() < (long)this.capacity()) {
            this.isFull().signal();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(Dispatcher dispatcher) {
        ObjectRef message = ObjectRef.create(null);
        try {
            this.inboxLock().lockInterruptibly();
            if (!this.enableConcurrent() && this.numActiveThreads() != 0) {
                return;
            }
            message.elem = this.messages().poll();
            if ((InboxMessage)message.elem == null) {
                return;
            }
            this.numActiveThreads_$eq(this.numActiveThreads() + 1);
            RpcTimeMetrics$.MODULE$.updateTime((InboxMessage)message.elem, RpcTimeMetrics$Dequeue$.MODULE$);
            this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().decrementAndGet();
            this.signalNotFull();
        }
        finally {
            this.inboxLock().unlock();
        }
        while (true) {
            this.safelyCall(this.endpoint(), this.endpointRef().name(), (InboxMessage)message.elem, (Function0<BoxedUnit>)new Serializable(this, dispatcher, message){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Inbox $outer;
                private final Dispatcher dispatcher$1;
                private final ObjectRef message$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$Inbox$$processInternal(this.dispatcher$1, (InboxMessage)this.message$2.elem);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dispatcher$1 = dispatcher$1;
                    this.message$2 = message$2;
                }
            });
            try {
                this.inboxLock().lockInterruptibly();
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    return;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    return;
                }
                RpcTimeMetrics$.MODULE$.updateTime((InboxMessage)message.elem, RpcTimeMetrics$Dequeue$.MODULE$);
                this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().decrementAndGet();
                this.signalNotFull();
                continue;
            }
            finally {
                this.inboxLock().unlock();
                continue;
            }
            break;
        }
    }

    public void post(InboxMessage message) {
        try {
            this.inboxLock().lockInterruptibly();
            if (this.stopped()) {
                this.onDrop(message);
            } else {
                this.addMessage(message);
                RpcTimeMetrics$.MODULE$.updateTime(message, RpcTimeMetrics$Enqueue$.MODULE$);
                this.metrics().updateMaxLength();
            }
            return;
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public void stop() {
        try {
            this.inboxLock().lockInterruptibly();
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                this.metrics().dump();
                this.addMessage(OnStop$.MODULE$);
            }
            return;
        }
        finally {
            this.metrics().close();
            this.inboxLock().unlock();
        }
    }

    public boolean isEmpty() {
        try {
            this.inboxLock().lockInterruptibly();
            return this.messages().isEmpty();
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Inbox $outer;
            private final InboxMessage message$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Drop ", " because ", " is stopped"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.message$3, this.$outer.endpointRef()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$3 = message$3;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void safelyCall(RpcEndpoint endpoint, String endpointRefName, InboxMessage message, Function0<BoxedUnit> action) {
        try {
            try {
                action.apply$mcV$sp();
                return;
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    if (throwable2 == null) throw throwable;
                    Throwable throwable3 = throwable2;
                    this.dealWithFatalError$1(throwable3, endpointRefName);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    return;
                }
                Throwable e = (Throwable)option.get();
                try {
                    endpoint.onError(e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable5);
                    if (option2.isEmpty()) {
                        if (throwable5 == null) throw throwable4;
                        Throwable throwable6 = throwable5;
                        this.dealWithFatalError$1(throwable6, endpointRefName);
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit4;
                        Throwable ee = (Throwable)option2.get();
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Ignoring error";
                                }
                            }, ee);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            this.logError((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Ignoring error";
                                }
                            }, ee);
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit5 = boxedUnit4;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit6 = boxedUnit;
            }
            return;
        }
        finally {
            RpcTimeMetrics$.MODULE$.updateTime(message, RpcTimeMetrics$Process$.MODULE$);
            this.metrics().update(message);
        }
    }

    public int getNumActiveThreads() {
        try {
            this.inboxLock().lockInterruptibly();
            return this.numActiveThreads();
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    private final void dealWithFatalError$1(Throwable fatal, String endpointRefName$1) {
        this.inboxLock().lockInterruptibly();
        Predef$.MODULE$.assert(this.numActiveThreads() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The number of active threads should be positive.";
            }
        });
        this.numActiveThreads_$eq(this.numActiveThreads() - 1);
        this.logError((Function0<String>)new Serializable(this, endpointRefName$1){
            public static final long serialVersionUID = 0L;
            private final String endpointRefName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"An error happened while processing message in the inbox for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.endpointRefName$1}));
            }
            {
                this.endpointRefName$1 = endpointRefName$1;
            }
        }, fatal);
        throw fatal;
        finally {
            this.inboxLock().unlock();
        }
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint, CelebornConf conf, RpcMetricsTracker metrics) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        this.conf = conf;
        this.metrics = metrics;
        Logging$class.$init$(this);
        this.capacity = BoxesRunTime.unboxToInt((Object)conf.get(CelebornConf$.MODULE$.RPC_INBOX_CAPACITY()));
        this.inboxLock = new ReentrantLock();
        this.isFull = this.inboxLock().newCondition();
        this.messages = new LinkedList();
        this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount = new AtomicLong(0L);
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        metrics.init((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Inbox $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        try {
            this.inboxLock().lockInterruptibly();
            this.messages().add(OnStart$.MODULE$);
            RpcTimeMetrics$.MODULE$.updateTime(OnStart$.MODULE$, RpcTimeMetrics$Enqueue$.MODULE$);
            metrics.updateMaxLength();
            this.org$apache$celeborn$common$rpc$netty$Inbox$$messageCount().incrementAndGet();
            return;
        }
        finally {
            this.inboxLock().unlock();
        }
    }
}

