/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.sasl;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.sasl.SaslUtils;
import org.apache.celeborn.common.network.sasl.SecretRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornSaslServer {
    private static final Logger logger = LoggerFactory.getLogger(CelebornSaslServer.class);
    private SaslServer saslServer;

    public CelebornSaslServer(String saslMechanism, @Nullable Map<String, String> saslProps, @Nullable CallbackHandler callbackHandler) {
        Preconditions.checkNotNull((Object)saslMechanism);
        SaslUtils.initializeSaslProviders();
        try {
            this.saslServer = Sasl.createSaslServer(saslMechanism, null, "default", saslProps, callbackHandler);
        }
        catch (SaslException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized boolean isComplete() {
        return this.saslServer != null && this.saslServer.isComplete();
    }

    public synchronized Object getNegotiatedProperty(String name) {
        return this.saslServer.getNegotiatedProperty(name);
    }

    public synchronized byte[] response(byte[] token) {
        try {
            return this.saslServer != null ? this.saslServer.evaluateResponse(token) : SaslUtils.EMPTY_BYTE_ARRAY;
        }
        catch (SaslException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void dispose() {
        if (this.saslServer != null) {
            try {
                this.saslServer.dispose();
            }
            catch (SaslException saslException) {
            }
            finally {
                this.saslServer = null;
            }
        }
    }

    static class DigestCallbackHandler
    implements CallbackHandler {
        private final SecretRegistry secretRegistry;
        private final TransportClient client;
        private String userName = null;

        DigestCallbackHandler(TransportClient client, SecretRegistry secretRegistry) {
            this.client = (TransportClient)Preconditions.checkNotNull((Object)client);
            this.secretRegistry = (SecretRegistry)Preconditions.checkNotNull((Object)secretRegistry);
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException, SaslException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    String encodedName;
                    logger.trace("SASL server callback: setting username");
                    NameCallback nc = (NameCallback)callback;
                    String string = encodedName = nc.getName() != null ? nc.getName() : nc.getDefaultName();
                    if (encodedName == null) {
                        throw new SaslException("No username provided by client");
                    }
                    this.userName = SaslUtils.decodeIdentifier(encodedName);
                    this.client.setClientId(this.userName);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    logger.trace("SASL server callback: setting password");
                    PasswordCallback pc = (PasswordCallback)callback;
                    String secret = this.secretRegistry.getSecretKey(this.userName);
                    if (secret == null) {
                        throw new RuntimeException("Registration information not found for " + this.userName);
                    }
                    pc.setPassword(SaslUtils.encodePassword(secret));
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    logger.trace("SASL server callback: setting realm");
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authId = ac.getAuthenticationID();
                    String authzId = ac.getAuthorizationID();
                    ac.setAuthorized(authId.equals(authzId));
                    if (ac.isAuthorized()) {
                        ac.setAuthorizedID(authzId);
                    }
                    logger.debug("SASL Authorization complete, authorized set to {}", (Object)ac.isAuthorized());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized callback: " + callback);
            }
        }
    }
}

