/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.CelebornSortBasedPusher;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputCollector;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornMapOutputCollector<K, V>
implements MapOutputCollector<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(CelebornMapOutputCollector.class);
    private Class<K> keyClass;
    private Class<V> valClass;
    private Task.TaskReporter reporter;
    private CelebornSortBasedPusher<K, V> celebornSortBasedPusher;
    private int numReducers;

    public void init(MapOutputCollector.Context context) throws IOException {
        JobConf jobConf = context.getJobConf();
        this.reporter = context.getReporter();
        this.keyClass = jobConf.getMapOutputKeyClass();
        this.valClass = jobConf.getMapOutputValueClass();
        context.getMapTask().getTaskID().getId();
        this.numReducers = jobConf.getNumReduceTasks();
        int IOBufferSize = jobConf.getInt("mapreduce.task.io.sort.mb", 100);
        if ((IOBufferSize & 0x7FF) != IOBufferSize) {
            throw new IOException("Invalid \"mapreduce.task.io.sort.mb\": " + IOBufferSize);
        }
        CelebornConf celebornConf = HadoopUtils.fromYarnConf(jobConf);
        JobConf celebornAppendConf = new JobConf("celeborn.xml");
        String lmHost = celebornAppendConf.get("celeborn.lifecycleManager.host");
        int lmPort = Integer.parseInt(celebornAppendConf.get("celeborn.lifecycleManager.port"));
        String applicationAttemptId = celebornAppendConf.get("celeborn.applicationId");
        logger.info("Mapper initialized with celeborn {} {} {} {}", new Object[]{lmHost, lmPort, applicationAttemptId, IOBufferSize});
        UserIdentifier userIdentifier = new UserIdentifier(celebornConf.userSpecificTenant(), celebornConf.userSpecificUserName());
        float spiller = jobConf.getFloat("mapreduce.map.sort.spill.percent", 0.8f);
        int pushSize = (int)((float)(IOBufferSize << 20) * spiller);
        SerializationFactory serializationFactory = new SerializationFactory((Configuration)jobConf);
        this.celebornSortBasedPusher = new CelebornSortBasedPusher(jobConf.getNumMapTasks(), jobConf.getNumReduceTasks(), context.getMapTask().getTaskID().getTaskID().getId(), context.getMapTask().getTaskID().getId(), serializationFactory.getSerializer(this.keyClass), serializationFactory.getSerializer(this.valClass), IOBufferSize << 20, pushSize, jobConf.getOutputKeyComparator(), this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES), this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS), ShuffleClient.get(applicationAttemptId, lmHost, lmPort, celebornConf, userIdentifier), celebornConf);
    }

    public void collect(K key, V value, int partition) throws IOException {
        this.reporter.progress();
        if (key.getClass() != this.keyClass) {
            throw new IOException("Type mismatch in key from map: expected " + this.keyClass.getName() + ", received " + key.getClass().getName());
        }
        if (value.getClass() != this.valClass) {
            throw new IOException("Type mismatch in value from map: expected " + this.valClass.getName() + ", received " + value.getClass().getName());
        }
        if (partition < 0 || partition >= this.numReducers) {
            throw new IOException("Illegal partition for " + key + " (" + partition + ")");
        }
        this.celebornSortBasedPusher.checkException();
        this.celebornSortBasedPusher.insert(key, value, partition);
    }

    public void close() throws IOException {
        logger.info("Mapper collector close");
        this.reporter.progress();
        this.celebornSortBasedPusher.close();
        this.celebornSortBasedPusher.checkException();
    }

    public void flush() throws IOException {
        logger.info("Mapper collector flush");
        this.celebornSortBasedPusher.flush();
        this.celebornSortBasedPusher.checkException();
        this.reporter.progress();
    }
}

