/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.scope;

import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskScopeFormat;

public class ShuffleScopeFormat
extends ScopeFormat {
    public static final String SCOPE_SHUFFLE_ID = ShuffleScopeFormat.asVariable((String)"shuffle_id");

    public ShuffleScopeFormat(String format, TaskScopeFormat parentFormat) {
        super(format, (ScopeFormat)parentFormat, new String[]{SCOPE_HOST, SCOPE_TASKMANAGER_ID, SCOPE_JOB_ID, SCOPE_JOB_NAME, SCOPE_TASK_VERTEX_ID, SCOPE_TASK_ATTEMPT_ID, SCOPE_TASK_NAME, SCOPE_TASK_SUBTASK_INDEX, SCOPE_TASK_ATTEMPT_NUM, SCOPE_SHUFFLE_ID});
    }

    public String[] formatScope(TaskMetricGroup parent, int shuffleId) {
        String[] template = this.copyTemplate();
        String[] values = new String[]{parent.parent().parent().hostname(), parent.parent().parent().taskManagerId(), ShuffleScopeFormat.valueOrNull((Object)parent.parent().jobId()), ShuffleScopeFormat.valueOrNull((Object)parent.parent().jobName()), ShuffleScopeFormat.valueOrNull((Object)parent.vertexId()), ShuffleScopeFormat.valueOrNull((Object)parent.executionId()), ShuffleScopeFormat.valueOrNull((Object)parent.taskName()), String.valueOf(parent.subtaskIndex()), String.valueOf(parent.attemptNumber()), ShuffleScopeFormat.valueOrNull((Object)shuffleId)};
        return this.bindVariables(template, values);
    }

    public static ShuffleScopeFormat fromConfig(String format, TaskScopeFormat parent) {
        return new ShuffleScopeFormat(format, parent);
    }
}

