/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.dump.ShuffleQueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.ShuffleIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ShuffleScopeFormat;
import org.apache.flink.util.Preconditions;

public class ShuffleMetricGroup
extends ComponentMetricGroup<TaskMetricGroup> {
    private final int shuffleId;
    private final ShuffleIOMetricGroup ioMetrics;

    public ShuffleMetricGroup(MetricGroup taskIOMetricGroup, int shuffleId, String scopeFormat) {
        this((TaskMetricGroup)((TaskIOMetricGroup)taskIOMetricGroup).parentMetricGroup, shuffleId, scopeFormat);
    }

    public ShuffleMetricGroup(TaskMetricGroup parent, int shuffleId, String scopeFormat) {
        super(parent.registry, ShuffleScopeFormat.fromConfig(scopeFormat, parent.registry.getScopeFormats().getTaskFormat()).formatScope((TaskMetricGroup)Preconditions.checkNotNull((Object)parent), shuffleId), (AbstractMetricGroup)parent);
        this.shuffleId = shuffleId;
        this.ioMetrics = new ShuffleIOMetricGroup(this);
    }

    public final TaskMetricGroup parent() {
        return (TaskMetricGroup)this.parent;
    }

    public int shuffleId() {
        return this.shuffleId;
    }

    public ShuffleIOMetricGroup getIOMetricGroup() {
        return this.ioMetrics;
    }

    protected ShuffleQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new ShuffleQueryScopeInfo(((TaskManagerJobMetricGroup)((TaskMetricGroup)this.parent).parent).jobId.toString(), ((TaskMetricGroup)this.parent).vertexId.toString(), ((TaskMetricGroup)this.parent).subtaskIndex, ((TaskMetricGroup)this.parent).attemptNumber(), this.shuffleId);
    }

    public void close() {
        super.close();
    }

    protected void putVariables(Map<String, String> variables) {
        variables.put(ShuffleScopeFormat.SCOPE_SHUFFLE_ID, String.valueOf(this.shuffleId));
    }

    protected Iterable<? extends ComponentMetricGroup<?>> subComponents() {
        return Collections.emptyList();
    }

    protected String getGroupName(CharacterFilter filter) {
        return "shuffle";
    }
}

