/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.server.common.service.config.BaseConfigServiceImpl;
import org.apache.celeborn.server.common.service.config.ConfigLevel;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.SystemConfig;
import org.apache.celeborn.server.common.service.config.TenantConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.yaml.snakeyaml.Yaml;

public class FsConfigServiceImpl
extends BaseConfigServiceImpl
implements ConfigService {
    private static final String CONF_TENANT_ID = "tenantId";
    private static final String CONF_TENANT_USERS = "users";
    private static final String CONF_TENANT_NAME = "name";
    private static final String CONF_LEVEL = "level";
    private static final String CONF_CONFIG = "config";

    public FsConfigServiceImpl(CelebornConf celebornConf) throws IOException {
        super(celebornConf);
    }

    @Override
    public synchronized void refreshCache() throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(this.getConfigFile(System.getenv()));){
            HashMap<String, TenantConfig> tenantConfigs = new HashMap<String, TenantConfig>();
            HashMap<Pair, TenantConfig> tenantUserConfigs = new HashMap<Pair, TenantConfig>();
            List configs = (List)new Yaml().load((InputStream)fileInputStream);
            for (Map configMap : configs) {
                if (ConfigLevel.SYSTEM.name().equals(configMap.get(CONF_LEVEL))) {
                    if (configMap.containsKey(CONF_CONFIG)) {
                        this.systemConfigAtomicReference.set(new SystemConfig(this.celebornConf, this.getConfigs(configMap)));
                    }
                } else if (configMap.containsKey(CONF_TENANT_ID)) {
                    String tenantId = (String)configMap.get(CONF_TENANT_ID);
                    if (configMap.containsKey(CONF_CONFIG)) {
                        tenantConfigs.put(tenantId, new TenantConfig((ConfigService)this, tenantId, null, this.getConfigs(configMap)));
                    }
                    if (configMap.containsKey(CONF_TENANT_USERS)) {
                        for (Map userConfigMap : (List)configMap.get(CONF_TENANT_USERS)) {
                            if (!userConfigMap.containsKey(CONF_TENANT_NAME) || !userConfigMap.containsKey(CONF_CONFIG)) continue;
                            String name = (String)userConfigMap.get(CONF_TENANT_NAME);
                            tenantUserConfigs.put(Pair.of((Object)tenantId, (Object)name), new TenantConfig((ConfigService)this, tenantId, name, this.getConfigs(userConfigMap)));
                        }
                    }
                }
                this.tenantConfigAtomicReference.set(tenantConfigs);
                this.tenantUserConfigAtomicReference.set(tenantUserConfigs);
            }
        }
    }

    private Map<String, String> getConfigs(Map<String, Object> configMap) {
        Map configs = (Map)configMap.get(CONF_CONFIG);
        if (configs == null) {
            return Collections.emptyMap();
        }
        return configs.entrySet().stream().filter(config -> config.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, config -> config.getValue().toString()));
    }

    private File getConfigFile(Map<String, String> env) throws IOException {
        File configFile = this.celebornConf.dynamicConfigStoreFsPath().isEmpty() ? new File(env.getOrDefault("CELEBORN_CONF_DIR", env.getOrDefault("CELEBORN_HOME", ".") + File.separator + "conf") + File.separator + "dynamicConfig.yaml") : new File((String)this.celebornConf.dynamicConfigStoreFsPath().get());
        String configPath = configFile.getPath();
        if (!configFile.exists()) {
            throw new IOException(String.format("Dynamic config file %s does not exist", configPath));
        }
        if (!configFile.isFile()) {
            throw new IOException(String.format("Dynamic config file %s is not a normal file", configPath));
        }
        return configFile;
    }
}

