/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.MapFileMeta;
import org.apache.celeborn.common.util.FileChannelUtils;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.service.deploy.worker.memory.BufferQueue;
import org.apache.celeborn.service.deploy.worker.memory.BufferRecycler;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.MapPartitionDataReader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapPartitionData
implements MemoryManager.ReadBufferTargetChangeListener {
    public static final Logger logger = LoggerFactory.getLogger(MapPartitionData.class);
    private final DiskFileInfo diskFileInfo;
    private final MapFileMeta mapFileMeta;
    private final ExecutorService readExecutor;
    private final ConcurrentHashMap<Long, MapPartitionDataReader> readers = JavaUtils.newConcurrentHashMap();
    private FileChannel dataFileChanel;
    private FileChannel indexChannel;
    private long indexSize;
    private volatile boolean isReleased = false;
    private final BufferQueue bufferQueue = new BufferQueue();
    private AtomicBoolean bufferQueueInitialized = new AtomicBoolean(false);
    private MemoryManager memoryManager = MemoryManager.instance();
    private Consumer<Long> recycleStream;
    private int minReadBuffers;
    private int maxReadBuffers;
    private int minBuffersToTriggerRead;
    private AtomicBoolean hasReadingTask = new AtomicBoolean(false);

    public MapPartitionData(int minReadBuffers, int maxReadBuffers, ConcurrentHashMap<String, ExecutorService> storageFetcherPool, int threadsPerMountPoint, DiskFileInfo diskFileInfo, Consumer<Long> recycleStream, int minBuffersToTriggerRead) throws IOException {
        this.recycleStream = recycleStream;
        this.diskFileInfo = diskFileInfo;
        this.mapFileMeta = (MapFileMeta)diskFileInfo.getFileMeta();
        this.minReadBuffers = minReadBuffers;
        this.maxReadBuffers = maxReadBuffers;
        this.updateBuffersTarget((this.minReadBuffers + this.maxReadBuffers) / 2 + 1);
        logger.debug("read map partition {} with {} {}", new Object[]{diskFileInfo.getFilePath(), this.bufferQueue.getLocalBuffersTarget(), this.mapFileMeta.getBufferSize()});
        this.minBuffersToTriggerRead = minBuffersToTriggerRead;
        this.readExecutor = storageFetcherPool.computeIfAbsent(this.mapFileMeta.getMountPoint(), k -> Executors.newFixedThreadPool(threadsPerMountPoint, new ThreadFactoryBuilder().setNameFormat(this.mapFileMeta.getMountPoint() + "-reader-thread-%d").setUncaughtExceptionHandler((t1, t2) -> logger.warn("StorageFetcherPool thread:{}:{}", (Object)t1, (Object)t2)).build()));
        this.dataFileChanel = FileChannelUtils.openReadableFileChannel((String)diskFileInfo.getFilePath());
        this.indexChannel = FileChannelUtils.openReadableFileChannel((String)diskFileInfo.getIndexPath());
        this.indexSize = this.indexChannel.size();
        MemoryManager.instance().addReadBufferTargetChangeListener(this);
    }

    private synchronized void updateBuffersTarget(int buffersTarget) {
        int currentBuffersTarget = buffersTarget;
        if (currentBuffersTarget < this.minReadBuffers) {
            currentBuffersTarget = this.minReadBuffers;
        }
        if (currentBuffersTarget > this.maxReadBuffers) {
            currentBuffersTarget = this.maxReadBuffers;
        }
        this.bufferQueue.setLocalBuffersTarget(currentBuffersTarget);
    }

    public void setupDataPartitionReader(int startSubIndex, int endSubIndex, long streamId, Channel channel) {
        MapPartitionDataReader mapPartitionDataReader = new MapPartitionDataReader(startSubIndex, endSubIndex, this.diskFileInfo, streamId, channel, () -> this.recycleStream.accept(streamId));
        this.readers.put(streamId, mapPartitionDataReader);
    }

    public void tryRequestBufferOrRead() {
        if (this.bufferQueueInitialized.compareAndSet(false, true)) {
            this.bufferQueue.tryApplyNewBuffers(this.readers.size(), this.mapFileMeta.getBufferSize(), this::onBuffer);
        } else {
            this.triggerRead();
        }
    }

    public void onBuffer(List<ByteBuf> buffers, Throwable throwable) {
        if (this.isReleased) {
            buffers.forEach(this.memoryManager::recycleReadBuffer);
            return;
        }
        if (throwable != null) {
            for (MapPartitionDataReader reader : this.readers.values()) {
                reader.recycleOnError(throwable);
            }
            return;
        }
        this.bufferQueue.add(buffers);
        if (this.bufferQueue.size() >= Math.min(this.bufferQueue.getLocalBuffersTarget() / 2 + 1, this.minBuffersToTriggerRead)) {
            this.triggerRead();
        }
    }

    public void recycle(ByteBuf buffer) {
        if (this.isReleased) {
            this.memoryManager.recycleReadBuffer(buffer);
            return;
        }
        this.bufferQueue.recycle(buffer);
        if (this.bufferQueue.size() >= Math.min(this.bufferQueue.getLocalBuffersTarget() / 2 + 1, this.minBuffersToTriggerRead)) {
            this.triggerRead();
        }
        this.bufferQueue.tryApplyNewBuffers(this.readers.size(), this.mapFileMeta.getBufferSize(), this::onBuffer);
    }

    public synchronized void readBuffers() {
        this.hasReadingTask.set(false);
        if (this.isReleased) {
            return;
        }
        try {
            PriorityQueue sortedReaders = new PriorityQueue(this.readers.values().stream().filter(MapPartitionDataReader::shouldReadData).collect(Collectors.toList()));
            for (MapPartitionDataReader reader : sortedReaders) {
                reader.open(this.dataFileChanel, this.indexChannel, this.indexSize);
            }
            while (this.bufferQueue.bufferAvailable() && !sortedReaders.isEmpty()) {
                MapPartitionDataReader reader;
                BufferRecycler bufferRecycler = new BufferRecycler(this::recycle);
                reader = (MapPartitionDataReader)sortedReaders.poll();
                try {
                    reader.readData(this.bufferQueue, bufferRecycler);
                }
                catch (Throwable e) {
                    logger.error("reader exception, reader: {}, message: {}", new Object[]{reader, e.getMessage(), e});
                    reader.recycleOnError(e);
                }
            }
        }
        catch (Throwable e) {
            logger.error("Fatal: failed to read partition data. {}", (Object)e.getMessage(), (Object)e);
            for (MapPartitionDataReader reader : this.readers.values()) {
                reader.recycleOnError(e);
            }
        }
    }

    public void addReaderCredit(int numCredit, long streamId) {
        MapPartitionDataReader streamReader = this.getStreamReader(streamId);
        if (streamReader != null) {
            streamReader.addCredit(numCredit);
            this.readExecutor.submit(() -> streamReader.sendData());
        }
    }

    public void triggerRead() {
        if (this.hasReadingTask.compareAndSet(false, true)) {
            this.readExecutor.submit(() -> this.readBuffers());
        }
    }

    public MapPartitionDataReader getStreamReader(long streamId) {
        return this.readers.get(streamId);
    }

    public boolean releaseReader(Long streamId) {
        MapPartitionDataReader mapPartitionDataReader = this.readers.get(streamId);
        mapPartitionDataReader.release();
        if (mapPartitionDataReader.isFinished()) {
            logger.debug("release all for stream: {}", (Object)streamId);
            this.readers.remove(streamId);
            return true;
        }
        return false;
    }

    public void close() {
        logger.debug("release map data partition {}", (Object)this.diskFileInfo);
        this.bufferQueue.release();
        this.isReleased = true;
        IOUtils.closeQuietly((Closeable)this.dataFileChanel);
        IOUtils.closeQuietly((Closeable)this.indexChannel);
        MemoryManager.instance().removeReadBufferTargetChangeListener(this);
    }

    public String toString() {
        return "MapDataPartition{fileInfo=" + this.diskFileInfo.getFilePath() + '}';
    }

    public ConcurrentHashMap<Long, MapPartitionDataReader> getReaders() {
        return this.readers;
    }

    public DiskFileInfo getDiskFileInfo() {
        return this.diskFileInfo;
    }

    @Override
    public void onChange(long newMemoryTarget) {
        this.updateBuffersTarget((int)Math.ceil((double)newMemoryTarget * 1.0 / (double)this.mapFileMeta.getBufferSize()));
        this.bufferQueue.trim();
    }
}

