/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.congestcontrol;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TimeSlidingHub<N extends TimeSlidingNode> {
    protected final int intervalPerBucketInMills = 1000;
    protected final int timeWindowsInMills;
    private final int maxQueueSize;
    private Pair<N, Integer> sumInfo;
    private final LinkedBlockingDeque<Pair<Long, N>> _deque = new LinkedBlockingDeque();

    public TimeSlidingHub(int timeWindowsInSecs) {
        this.maxQueueSize = timeWindowsInSecs * 1000 / 1000;
        this.timeWindowsInMills = this.maxQueueSize * 1000;
        this.sumInfo = Pair.of(this.newEmptyNode(), (Object)0);
    }

    private void removeExpiredNodes() {
        long currentTime = this.currentTimeMillis();
        while (!this._deque.isEmpty() && currentTime - (Long)this._deque.getFirst().getLeft() >= (long)this.timeWindowsInMills) {
            Pair<Long, N> removed = this._deque.removeFirst();
            TimeSlidingNode nodeToSeparate = (TimeSlidingNode)this.sumInfo.getLeft();
            nodeToSeparate.separateNode((TimeSlidingNode)removed.getRight());
            this.sumInfo = Pair.of((Object)nodeToSeparate, (Object)((Integer)this.sumInfo.getRight() - 1));
        }
    }

    public synchronized Pair<N, Integer> sum() {
        this.removeExpiredNodes();
        return this.sumInfo;
    }

    public void add(N newNode) {
        this.add(this.currentTimeMillis(), newNode);
    }

    public synchronized void add(long currentTimestamp, N newNode) {
        if ((Integer)this.sumInfo.getRight() == 0) {
            this._deque.add(Pair.of((Object)currentTimestamp, newNode));
            this.sumInfo = Pair.of((Object)newNode.clone(), (Object)1);
            return;
        }
        Pair lastNode = this._deque.getLast();
        long timeDiff = currentTimestamp - (Long)lastNode.getLeft();
        if (timeDiff >= 1000L) {
            int nodesToAdd = (int)timeDiff / 1000;
            if (nodesToAdd >= this.maxQueueSize) {
                this._deque.clear();
                this._deque.add(Pair.of((Object)currentTimestamp, newNode));
                this.sumInfo = Pair.of((Object)newNode.clone(), (Object)1);
                return;
            }
            for (int i = 1; i < nodesToAdd; ++i) {
                N toAdd = this.newEmptyNode();
                lastNode = Pair.of((Object)((Long)lastNode.getLeft() + 1000L), toAdd);
                this._deque.add(lastNode);
            }
            this._deque.add(Pair.of((Object)((Long)lastNode.getLeft() + 1000L), newNode));
            TimeSlidingNode nodeToCombine = (TimeSlidingNode)this.sumInfo.getLeft();
            nodeToCombine.combineNode((TimeSlidingNode)newNode);
            this.sumInfo = Pair.of((Object)nodeToCombine, (Object)((Integer)this.sumInfo.getRight() + nodesToAdd));
            this.removeExpiredNodes();
            return;
        }
        if (timeDiff < 0L) {
            if (-timeDiff < (long)(1000 * ((Integer)this.sumInfo.getRight() - 1))) {
                Iterator<Pair<Long, N>> iter = this._deque.descendingIterator();
                while (iter.hasNext()) {
                    Pair<Long, N> curNode = iter.next();
                    if (currentTimestamp - (Long)curNode.getLeft() < 0L) continue;
                    ((TimeSlidingNode)curNode.getRight()).combineNode((TimeSlidingNode)newNode);
                    ((TimeSlidingNode)this.sumInfo.getLeft()).combineNode((TimeSlidingNode)newNode);
                    return;
                }
            }
            return;
        }
        ((TimeSlidingNode)lastNode.getRight()).combineNode((TimeSlidingNode)newNode);
        ((TimeSlidingNode)this.sumInfo.getLeft()).combineNode((TimeSlidingNode)newNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedBlockingDeque<Pair<Long, N>> linkedBlockingDeque = this._deque;
        synchronized (linkedBlockingDeque) {
            this._deque.clear();
            this.sumInfo = Pair.of(this.newEmptyNode(), (Object)0);
        }
    }

    protected abstract N newEmptyNode();

    @VisibleForTesting
    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static interface TimeSlidingNode
    extends Cloneable {
        public void combineNode(TimeSlidingNode var1);

        public void separateNode(TimeSlidingNode var1);

        public TimeSlidingNode clone();
    }
}

