/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import com.google.common.annotations.VisibleForTesting;
import java.util.ServiceLoader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.ConfigStore;

public class DynamicConfigServiceFactory {
    private static volatile ConfigService _INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigService getConfigService(CelebornConf celebornConf) {
        if (celebornConf.dynamicConfigStoreBackend().isEmpty()) {
            return null;
        }
        if (_INSTANCE != null) return _INSTANCE;
        Class<DynamicConfigServiceFactory> clazz = DynamicConfigServiceFactory.class;
        synchronized (DynamicConfigServiceFactory.class) {
            if (_INSTANCE != null) return _INSTANCE;
            String configStoreBackend = (String)celebornConf.dynamicConfigStoreBackend().get();
            for (ConfigStore configStore : ServiceLoader.load(ConfigStore.class)) {
                if (!configStore.getName().equalsIgnoreCase(configStoreBackend)) continue;
                configStoreBackend = configStore.getService();
                break;
            }
            _INSTANCE = (ConfigService)Utils.instantiateDynamicConfigStoreBackend((String)configStoreBackend, (CelebornConf)celebornConf);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _INSTANCE;
        }
    }

    @VisibleForTesting
    public static void reset() {
        if (_INSTANCE != null) {
            _INSTANCE.shutdown();
            _INSTANCE = null;
        }
    }
}

